package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.entity.activiti.ActHiActinstEntity;
import com.biz.eisp.activiti.runtime.cmd.JumpTaskCmd;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.service.TaskFlowControlService;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 
 * @Description:
 * @Author: xuduan 
 * @Date: 2018/4/17 上午10:49
 */
@Service("taskFlowControlService")
@Transactional
public class TaskFlowControlServiceImpl extends BaseServiceImpl implements TaskFlowControlService {
    private static final Logger logger = LoggerFactory.getLogger(TaskFlowControlServiceImpl.class);
    private static final String REASION_JUMP = "jump";
    private static final String EVENTNAME_CREATE = "create";
    private static final String EVENTNAME_ASSIGNMENT = "assignment";
    private static final String EVENTNAME_COMPLETE = "complete";
    private static final String EVENTNAME_DELETE = "delete";
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    RepositoryServiceImpl repositoryService;
    @Autowired
    private TaTaskService taTaskService;

    /**
     * 跳转至指定活动节点
     */
    @Override
    public void jump(OperationVo operationVo) throws Exception {
        try {

            TaskEntity currentTaskEntity = (TaskEntity) taskService.createTaskQuery().taskId(operationVo.getTaskId()).singleResult();
            ActivityImpl activity = getActivity(currentTaskEntity.getProcessDefinitionId(), operationVo.getTaskDefKey());
            // 构造详细审批意见
            String detailComment = CommentUtil.buildRejectPreComment(currentTaskEntity.getName(), ResourceConfigUtils.getCreateName(),
                    operationVo.getComment());
            // 添加审批意见信息
            taskService.addComment(operationVo.getTaskId(), operationVo.getProcessInstanceId(), detailComment);
            //currentTaskEntity.fireEvent(EVENTNAME_COMPLETE);
            CommandExecutor commandExecutor = ((RuntimeServiceImpl) runtimeService).getCommandExecutor();
            Map<String, Object> variables=new HashMap<>();
            variables.put("taskDefKey",operationVo.getTaskDefKey());
            variables.put("approveOpt", WorkFlowGlobals.OPT_REJECT_PRE);
            variables.put("processInstanceId",currentTaskEntity.getProcessInstanceId());
            commandExecutor.execute(new JumpTaskCmd(currentTaskEntity, activity, variables));
            doAfterJump(operationVo.getTaskId());
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
    @Override
    public ActivityImpl getActivity(String processDefId, String taskDefKey) {
        // 取得流程定义
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity) (repositoryService.getDeployedProcessDefinition(processDefId));
        List<ActivityImpl> activitiList = processDefinition.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            if (activityImpl.getId().equals(taskDefKey)) {
                return activityImpl;
            }
        }
        return null;
    }
    private void doAfterJump(String taskId) {
        ActHiActinstEntity actHiActinstEntity = this.findUniqueByProperty(ActHiActinstEntity.class,"taskId",taskId);
        if (actHiActinstEntity != null) {
            Timestamp nowTime = new Timestamp(new Date().getTime());
            actHiActinstEntity.setEndTime(nowTime);
            actHiActinstEntity.setDuration(nowTime.getTime() - actHiActinstEntity.getStartTime().getTime());
            taTaskService.updateEntity(actHiActinstEntity);
        }
    }
}
