package com.biz.eisp.activiti.runtime.transformer;

import java.util.Calendar;

import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.time.DateFormatUtils;

import com.biz.eisp.activiti.entity.activiti.ActHiTaskinstEntity;
import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.google.common.base.Function;

/**
 * 类简述.
 * <p>
 * 类的详细说明第一行<br>
 * 类的详细说明第二行
 * 
 * @author liukai
 * @version v1.0
 */
public class ActHiTaskinstEntityToHistoryTaskVo implements Function<ActHiTaskinstEntity, HistoryTaskVo> {

	private RepositoryService repositoryService;
	private TaTaskService taTaskService;
	private HistoryService historyService;

	public ActHiTaskinstEntityToHistoryTaskVo(RepositoryService repositoryService, HistoryService historyService,
			TaTaskService taTaskService) {
		this.repositoryService = repositoryService;
		this.historyService = historyService;
		this.taTaskService = taTaskService;
	}

	@Override
	public HistoryTaskVo apply(ActHiTaskinstEntity entity) {
		if (entity == null) {
			return null;
		}

		HistoryTaskVo vo = new HistoryTaskVo();
		String startTime = entity.getStartTime() == null ? ""
				: DateFormatUtils.format(entity.getStartTime(), "yyyy-MM-dd HH:mm:ss");
		String endTime = entity.getEndTime() == null ? ""
				: DateFormatUtils.format(entity.getEndTime(), "yyyy-MM-dd HH:mm:ss");

		long totalTimes = entity.getEndTime() == null
				? (Calendar.getInstance().getTimeInMillis() - entity.getStartTime().getTime())
				: (entity.getEndTime().getTime() - entity.getStartTime().getTime());

		long dayCount = totalTimes / (1000 * 60 * 60 * 24);// 计算天
		long restTimes = totalTimes % (1000 * 60 * 60 * 24);// 剩下的时间用于计于小时
		long hourCount = restTimes / (1000 * 60 * 60);// 小时
		restTimes = restTimes % (1000 * 60 * 60);
		long minuteCount = restTimes / (1000 * 60);

		String spendTimes = dayCount + "天" + hourCount + "小时" + minuteCount + "分";

		ProcessDefinition processDefinition = this.getProcessDefinition(entity.getProcDefId());

		String buisnessKey = entity.getProInsl().getBusinessKey();

		TaBaseBusinessObjEntity businessObj = taTaskService.get(TaBaseBusinessObjEntity.class, buisnessKey);

//		HistoricTaskInstance historicTaskInstance = historyService.createHistoricTaskInstanceQuery()
//				.taskDefinitionKey(entity.getTaskDefKey()).singleResult();

		vo.setAssignee(entity.getAssignee());
		vo.setStartTime(startTime);
		vo.setEndTime(endTime);
		vo.setSpendTimes(spendTimes);
		vo.setTaskName("dd");
		vo.setCreateUserName(businessObj.getTmPositionEntity().getPositionName());
		vo.setProcessInstanceId(entity.getProcInstId());
		vo.setProcessDefinitionId(entity.getProcDefId());
		vo.setProcessDefinitionKey(processDefinition.getKey());
		vo.setProcessDefinitionName(processDefinition.getName());
		vo.setId(entity.getId());

		return vo;
	}

	private ProcessDefinition getProcessDefinition(String processDefinitionId) {
		return repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
	}

}
