package com.biz.eisp.activiti.runtime.transformer;

import java.util.Calendar;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang3.time.DateFormatUtils;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.google.common.base.Function;

/**
 * 转换HistoricProcessInstance 为 MyInstanceVo.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class HistoricProcessInstanceToMyInstanceVo implements Function<HistoricProcessInstance, MyInstanceVo> {

	private RepositoryService repositoryService;
	private RuntimeService runtimeService;
	private TaskService taskService;
	private TaProcessInstanceService taProcessInstanceService;
	
	public HistoricProcessInstanceToMyInstanceVo(RepositoryService repositoryService,
			RuntimeService runtimeService, TaskService taskService, TaProcessInstanceService taProcessInstanceService) {
		this.repositoryService = repositoryService;
		this.runtimeService = runtimeService;
		this.taskService = taskService;
		this.taProcessInstanceService = taProcessInstanceService;
	}
	
	@Override
	public MyInstanceVo apply(HistoricProcessInstance hi) {
		String starttime = DateFormatUtils.format(hi.getStartTime(), "yyyy-MM-dd HH:mm:ss");
		String endtime = hi.getEndTime() == null ? 
					"" : DateFormatUtils.format(hi.getEndTime(), "yyyy-MM-dd HH:mm:ss");
		
		long totalTimes = hi.getEndTime() == null ? (Calendar.getInstance().getTimeInMillis()-hi.getStartTime().getTime()):(hi.getEndTime().getTime()-hi.getStartTime().getTime());
		
		long dayCount = totalTimes /(1000*60*60*24);//计算天
		long restTimes = totalTimes %(1000*60*60*24);//剩下的时间用于计于小时
		long hourCount = restTimes/(1000*60*60);//小时
		restTimes = restTimes % (1000*60*60);
		long minuteCount = restTimes / (1000*60);
		
		String spendTimes = dayCount+"天"+hourCount+"小时"+minuteCount+"分";
		ProcessDefinition processDefinition = getProcessDefinition(hi.getProcessDefinitionId());
		
		String activityName = "";//当前任务名称
		String activityUser = "";//当前任务签收人
		String taskId = "";//任务ID
		
		MyInstanceVo vo = new MyInstanceVo();
//		if(hi.getEndTime() == null){ //endtime为空表示流程实例未结束
			ProcessInstance pi = runtimeService.createProcessInstanceQuery().processInstanceId(hi.getId()).singleResult();
		
			vo.setActivityName(activityName);
			vo.setActivityUser(activityUser);
			vo.setEndTime(endtime);
			vo.setId(hi.getId());
			vo.setProcessDefinitionName(processDefinition.getName());
			vo.setProcessDefinitionId(hi.getProcessDefinitionId());
			vo.setProcessInstanceId(hi.getId());
			vo.setSpendTimes(spendTimes);
			vo.setStartTime(starttime);
			vo.setStartPositionCode(hi.getStartUserId());
			vo.setProcessDefinitionKey(processDefinition.getKey());
			
			if(pi != null) {
				String businessObjId = pi.getBusinessKey();
				
				TaBaseBusinessObjEntity taBaseBusinessObjEntity = taProcessInstanceService.get(TaBaseBusinessObjEntity.class, businessObjId);
				
				vo.setProcessTitle(taBaseBusinessObjEntity.getProcessTitle());
			}
			
//		}
		
		return vo;
	}

	private ProcessDefinition getProcessDefinition(String processDefinitionId) {
		ProcessDefinition processDefinition = repositoryService.
					createProcessDefinitionQuery().
					processDefinitionId(processDefinitionId).
					singleResult();
		return processDefinition;
	}
}
