package com.biz.eisp.activiti.runtime.transformer;

import org.activiti.engine.history.HistoricTaskInstance;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class HistoricTaskInstanceToHistoryTaskVo implements Function<HistoricTaskInstance, HistoryTaskVo> {

	@Override
	public HistoryTaskVo apply(HistoricTaskInstance entity) {
		if(entity == null) {
			return null;
		}
		
		HistoryTaskVo historyTaskVo = new HistoryTaskVo();
		
		String startTime = entity.getStartTime() == null ? ""
				: DateFormatUtils.format(entity.getStartTime(), "yyyy-MM-dd HH:mm:ss");
		String endTime = entity.getEndTime() == null ? ""
				: DateFormatUtils.format(entity.getEndTime(), "yyyy-MM-dd HH:mm:ss");

		historyTaskVo = new HistoryTaskVo();

		historyTaskVo.setAssignee(StringUtils.trimToEmpty(entity.getAssignee()));
		historyTaskVo.setDeleteReason(StringUtils.trimToEmpty(entity.getDeleteReason()));
		historyTaskVo.setStartTime(startTime);
		historyTaskVo.setEndTime(endTime);
		historyTaskVo.setTaskName(entity.getName());
		historyTaskVo.setProcessInstanceId(entity.getProcessInstanceId());
		
		return historyTaskVo;
	}

}
