package com.biz.eisp.activiti.runtime.transformer;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

import com.biz.eisp.activiti.runtime.entity.TaRejectRecordEntity;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TaRejectRecordVoToTaRejectRecordEntity implements Function<TaRejectRecordVo, TaRejectRecordEntity>{

	private TaRejectRecordService taRejectRecordService;
	
	public TaRejectRecordVoToTaRejectRecordEntity(TaRejectRecordService taRejectRecordService) {
		this.taRejectRecordService = taRejectRecordService;
	}
	
	@Override
	public TaRejectRecordEntity apply(TaRejectRecordVo vo) {
		if(vo == null) {
			return null;
		}
		
		TaRejectRecordEntity entity = null;
		if(StringUtils.isNotBlank(vo.getId())) {
			entity = taRejectRecordService.get(TaRejectRecordEntity.class, vo.getId());
		} else {
			entity = new  TaRejectRecordEntity();
		}
//		
//		entity.setBusinessObjId(vo.getBusinessObjId());
////		entity.setCreateTime(DataUtils.);
//		entity.setCreateUserName(vo.getCreateUserName());
//		entity.setPositionCode(entity.getPositionCode());
//		entity.setPositionName(entity.getPositionName());
////		entity.setPreNodeTime(entity);
//		entity.setProcessDefinitionName(entity.getProcessDefinitionName());
//		entity.setProcessInstanceId(entity.getProcessInstanceId());
//		entity.setProcessTitle(entity.getProcessTitle());
//		entity.setReadStatus(entity.getReadStatus());
//		
		BeanUtils.copyProperties(vo, entity);
		return entity;
	}

}
