package com.biz.eisp.activiti.runtime.transformer;

import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.time.DateFormatUtils;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TaskToMyTaskVo implements Function<Task, MyTaskVo>{

	private RepositoryService repositoryService;
	private TaTaskService taTaskService;
	
	public TaskToMyTaskVo(RepositoryService repositoryService, 
			TaTaskService taTaskService, HistoryService historyService) {
		this.repositoryService = repositoryService;
		this.taTaskService = taTaskService;
	}
	
	@Override
	public MyTaskVo apply(Task task) {
		if(task == null) {
			return null;
		}
		
		MyTaskVo myTaskVo = new MyTaskVo();
		
		myTaskVo.setAssignee(task.getAssignee()); 
		myTaskVo.setPreNodetime(DateFormatUtils.format(task.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
		if(task.getDueDate() != null) {
			myTaskVo.setDueDate(DateFormatUtils.format(task.getDueDate(), "yyyy-MM-dd HH:mm:ss"));
		}
		myTaskVo.setProcessDefinitionId(task.getProcessDefinitionId());
		myTaskVo.setProcessInstanceId(task.getProcessInstanceId());
		myTaskVo.setTaskDefinitionKey(task.getTaskDefinitionKey());
		myTaskVo.setTaskId(task.getId());
		myTaskVo.setTaskName(task.getName());
		myTaskVo.setId(task.getId());
		
		
		ProcessDefinition processDefinition = this.getProcessDefinition(task.getProcessDefinitionId());
		myTaskVo.setProcessDefinitionName(processDefinition.getName());
		myTaskVo.setProcessDefinitionKey(processDefinition.getKey());
		
		//设置发起人，发起时间
		String businessObjId = taTaskService.getBusinessObjIdByTask(task);
		TaBaseBusinessObjEntity baseBusinessObjEntity = taTaskService.get(TaBaseBusinessObjEntity.class, businessObjId);
		TmPositionEntity tmPositionEntity = (TmPositionEntity)baseBusinessObjEntity.getTmPositionEntity();
		myTaskVo.setCreateUserName(tmPositionEntity.getPositionName());
		myTaskVo.setCreateTime(DateFormatUtils.format(baseBusinessObjEntity.getCreatetime(), "yyyy-MM-dd HH:mm:ss"));
		myTaskVo.setProcessTitle(baseBusinessObjEntity.getProcessTitle());
		myTaskVo.setAssignee(task.getAssignee());
		myTaskVo.setRumTimeStatusDesc(baseBusinessObjEntity.getTaRuntimeStatusEntity().getDescription());
		
		return myTaskVo;
	}

	private ProcessDefinition getProcessDefinition(String processDefinitionId) {
		return repositoryService.
					createProcessDefinitionQuery().
					processDefinitionId(processDefinitionId).
					singleResult();
	}
}
