package com.biz.eisp.activiti.runtime.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;



/** 
 * 
 * 工具类：关于工作流的驳回上一步和驳回发起人的工具
 * @author wan
 * @version v1.0
 */

public class RejectTaskUtil {
	private List<String> list = new ArrayList<String>();//装该节点的全部上级节点
	
	private HistoryService historyService;
	private RepositoryService repositoryService;
	private RuntimeService runtimeService;
	private TaskService taskService;
	private TaTaskService taTaskService;
	
	public RejectTaskUtil() {
		list.clear();
		historyService = (HistoryService) ApplicationContextUtils.getContext().getBean("historyService");
		repositoryService = (RepositoryService) ApplicationContextUtils.getContext().getBean("repositoryService");
		runtimeService = (RuntimeService) ApplicationContextUtils.getContext().getBean("runtimeService");
		taskService = (TaskService) ApplicationContextUtils.getContext().getBean("taskService");
		taTaskService = (TaTaskService) ApplicationContextUtils.getContext().getBean("taTaskService");
	}
	
	public boolean rollBackFirst(String taskId,String firstNodeId,String comment)throws Exception{
		Map<String, Object> variables;
		HistoricTaskInstance currTask = historyService
				.createHistoricTaskInstanceQuery().taskId(taskId)
				.singleResult();
		ProcessInstance instance = runtimeService.createProcessInstanceQuery()
				.processInstanceId(currTask.getProcessInstanceId())
				.singleResult();
		variables = instance.getProcessVariables();
		ProcessDefinitionEntity definition = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(currTask
						.getProcessDefinitionId());
		ActivityImpl currActivity = ((ProcessDefinitionImpl) definition).findActivity(currTask.getTaskDefinitionKey());
		List<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
		List<PvmTransition> pvmTransitionList = currActivity.getOutgoingTransitions();
		for (PvmTransition pvmTransition : pvmTransitionList) {
			oriPvmTransitionList.add(pvmTransition);
		}
		pvmTransitionList.clear();
		List<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
		
		ActivityImpl nextActivityImpl = ((ProcessDefinitionImpl) definition).findActivity(firstNodeId);
		TransitionImpl newTransition = currActivity.createOutgoingTransition();
		newTransition.setDestination(nextActivityImpl);
		newTransitions.add(newTransition);
		
		List<Task> tasks = taskService.createTaskQuery()
				.processInstanceId(instance.getId())
				.taskDefinitionKey(currTask.getTaskDefinitionKey()).list();
		
		for (Task task : tasks) {
			taskService.addComment(task.getId(),instance.getId(), CommentUtil.buildRejectApplyComment(task.getName(), ResourceConfigUtils.getCreateName(), comment));
			taskService.complete(task.getId(), variables);
		}
		for (TransitionImpl transitionImpl : newTransitions) {
			currActivity.getOutgoingTransitions().remove(transitionImpl);
		}
		for (PvmTransition pvmTransition : oriPvmTransitionList) {
			pvmTransitionList.add(pvmTransition);
		}
		
		updateBusinessEntity(instance);
		
		return true;
	}
	
	private void updateBusinessEntity(ProcessInstance instance) {
		TaBaseBusinessObjEntity taBaseBusinessObjEntity = taTaskService.get(TaBaseBusinessObjEntity.class, instance.getBusinessKey());
		TaRuntimeStatusEntity taRuntimeStatusEntity = taTaskService.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "reject");
		taBaseBusinessObjEntity.setTaRuntimeStatusEntity(taRuntimeStatusEntity);
		taTaskService.updateEntity(taBaseBusinessObjEntity);
	}
	
	/**
	 * 返回到上一级
	 * @author wan
	 * @param taskId 当前的taskId
	 * @param target	需要返回的目标节点，是节点id
	 * @param comment	数据
	 * @return
	 * @throws Exception
	 */
	public boolean rollBackAbove(String taskId, String target,String comment)throws Exception{
		Map<String, Object> variables;
		HistoricTaskInstance currTask = historyService
				.createHistoricTaskInstanceQuery().taskId(taskId)
				.singleResult();
		ProcessInstance instance = runtimeService.createProcessInstanceQuery()
				.processInstanceId(currTask.getProcessInstanceId())
				.singleResult();
		if (instance == null) {
			return false;
		}
		variables = instance.getProcessVariables();
		ProcessDefinitionEntity definition = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
				.getDeployedProcessDefinition(currTask
						.getProcessDefinitionId());
		if (definition == null) {
			return false;
		}
		ActivityImpl currActivity = ((ProcessDefinitionImpl) definition).findActivity(currTask.getTaskDefinitionKey());
		List<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
		List<PvmTransition> pvmTransitionList = currActivity.getOutgoingTransitions();
		for (PvmTransition pvmTransition : pvmTransitionList) {
			oriPvmTransitionList.add(pvmTransition);
		}
		pvmTransitionList.clear();
		List<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
		List<String> newTT = getAllAboveNode(currActivity.getId(), definition);//当前节点的上一个id
		for(String str : newTT){
			if(str.equals(target)){//destTaskkey上一个节点，通过数据库拿或者map
				ActivityImpl nextActivityImpl = ((ProcessDefinitionImpl) definition).findActivity(target);
				TransitionImpl newTransition = currActivity.createOutgoingTransition();
				newTransition.setDestination(nextActivityImpl);
				newTransitions.add(newTransition);
				break;
			}
		}
		List<Task> tasks = taskService.createTaskQuery()
				.processInstanceId(instance.getId())
				.taskDefinitionKey(currTask.getTaskDefinitionKey()).list();
		for (Task task : tasks) {
			taskService.addComment(task.getId(),instance.getId(), CommentUtil.buildRejectPreComment(task.getName(), ResourceConfigUtils.getCreateName(), comment));
			taskService.complete(task.getId(), variables);
		}
		for (TransitionImpl transitionImpl : newTransitions) {
			currActivity.getOutgoingTransitions().remove(transitionImpl);
		}
		for (PvmTransition pvmTransition : oriPvmTransitionList) {
			pvmTransitionList.add(pvmTransition);
		}
		return true;
	}
	public String getFirstNodeName(String taskId) throws Exception{
		String result = null;
		Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
		String pdId = task.getProcessDefinitionId();
		ProcessDefinition pd = repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).singleResult();
		InputStream is = repositoryService.getProcessModel(pd.getId());
		XMLStreamReader xtr = XMLInputFactory.newInstance().createXMLStreamReader(is);
		BpmnModel model = new BpmnXMLConverter().convertToBpmnModel(xtr); 
		Collection<FlowElement> elements = model.getMainProcess().getFlowElements();
		for(FlowElement fe : elements){
			if(fe instanceof StartEvent){
				List<SequenceFlow> flows = ((StartEvent)fe).getOutgoingFlows();
				for(SequenceFlow s : flows){
					result = s.getTargetRef();
				}
			}
		}
		return result;
	}
	
	private List<String> getAllAboveNode(String actId,ProcessDefinitionEntity definition){
		List<String> list = new ArrayList<String>();//装该节点的全部上级节点
		//传入当前的节点id，然后查询出来
		ActivityImpl nowActivityNode = ((ProcessDefinitionImpl) definition).findActivity(actId);
		//该节点的全部来线
		List<PvmTransition> incomingTransitions = nowActivityNode.getIncomingTransitions();
		//遍历来线
		for(PvmTransition p : incomingTransitions){
			//上一个节点的节点id
			String aboveActId = p.getSource().getId();
			//查询到上一个节点
			ActivityImpl aboveNode = ((ProcessDefinitionImpl) definition).findActivity(aboveActId);//上一个节点的名字
			String aboveNodeType = (String) aboveNode.getProperties().get("type");//上一个节点的类型
			//上一个节点不是网关，开始节点,就ok
			if(!aboveNodeType.equals("exclusiveGateway") && !aboveNodeType.equals("startEvent")){
				list.add(aboveNode.getId());
			}else{//否则，继续查找上一个节点
				getAllAboveNode(aboveNode.getId(),definition);
			}
		}
		return list;
	}
}
