package com.biz.eisp.activiti.util;

import java.util.Date;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.base.utils.DateUtils;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class CommentUtil {

	public static final String DEFAULT_TASK_NODE = "DEFAULT_START";

	public static String buildComment(String taskName, String userInfo, Date date, String opt, String comment) {
		String dateStr = DateUtils.format(date, "yyyy-MM-dd hh:mm:ss");
		String info = 
				"<p><span>[</span><b>任务</b><span>]</span><i>" + taskName + "</i></p>"+
				"<p><span>[</span><b>操作人</b><span>]</span><i>" + userInfo + "</i></p>"+
				"<p><span>[</span><b>操作时间</b><span>]</span><i>" + dateStr + "</i></p>"+
				"<p><span>[</span><b>操作</b><span>]</span><i>" + CommentUtil.getOptVal(opt) + "</i></p>"+
				"<div style='clear: both;'></div>"+
				comment;
		return info;
	}
	
	public static String buildApplyComment(String userInfo) {
		return CommentUtil.buildComment("发起流程", userInfo, new Date(), WorkFlowGlobals.OPT_APPLY, "");
	}
	
	public static String buildPassComment(String taskName, String userInfo, String comment) {
		return CommentUtil.buildComment(taskName, userInfo, new Date(), WorkFlowGlobals.OPT_PASS, "<p><span>[</span><b>通过意见</b><span>]</span><i>" + comment + "</i></p><div style='clear: both;'></div>");
	}
	
	public static String buildRejectApplyComment(String taskName, String userInfo, String comment) {
		return CommentUtil.buildComment(taskName, userInfo, new Date(), WorkFlowGlobals.OPT_REJECT_APPLY, "<p><span>[</span><b>驳回意见</b><span>]</span><i>" + comment + "</i></p><div style='clear: both;'></div>");
	}
	
	public static String buildRejectPreComment(String taskName, String userInfo, String comment) {
		return CommentUtil.buildComment(taskName, userInfo, new Date(), WorkFlowGlobals.OPT_REJECT_PRE, "<p><span>[</span><b>驳回意见</b><span>]</span><i>" + comment + "</i></p><div style='clear: both;'></div>");
	}
	
	public static String buildReassignComment(String taskName, String userInfo, String comment) {
		return CommentUtil.buildComment(taskName, userInfo, new Date(), WorkFlowGlobals.OPT_REASSIGN, "<p><span>[</span><b>委派意见</b><span>]</span><i>" + comment + "</i></p><div style='clear: both;'></div>");
	}
	
	public static String buildRecoverComment(String userInfo, String comment) {
		return CommentUtil.buildComment("流程追回", userInfo, new Date(), "流程追回", "");
	}
	
	public static String buildCloseComment(String userInfo, String comment) {
		return CommentUtil.buildComment("流程关闭", userInfo, new Date(), WorkFlowGlobals.OPT_CLOSE, "");
	}
	
	public static String getOptVal(String opt) {
		if(WorkFlowGlobals.OPT_APPLY.equals(opt)) {
			return "发起流程";
		} else if (WorkFlowGlobals.OPT_PASS.equals(opt)) {
			return "审批通过";
		} else if (WorkFlowGlobals.OPT_REASSIGN.equals(opt)) {
			return "委派";
		} else if (WorkFlowGlobals.OPT_REJECT_APPLY.equals(opt)) {
			return "驳回发起人";
		} else if (WorkFlowGlobals.OPT_REJECT_PRE.equals(opt)) {
			return "驳回上一级";
		} else if (WorkFlowGlobals.OPT_CLOSE.equals(opt)) {
			return "关闭流程";
		}
		return "";
	}
	
}
