package com.biz.eisp.activiti.util;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

/**
 * Ehcache 缓存工具类
 *
 * @Description:
 * @ClassName: com.biz.orderDocker.util.EhcacheUtil
 * @author: Omar(OmarZhang)
 * @date: 2016年7月22日 下午7:16:51
 */
public final class EhcacheUtil {

    private static final CacheManager cacheManager = CacheManager.getInstance();

    private static Cache cache = null;

    static {
        cache = cacheManager.getCache("eternalCache");
    }

    /**
     * 放入值
     *
     * @param key
     * @param item
     * @Title: putItem
     * @author: Omar(OmarZhang)
     * @date: 2016年7月22日 下午7:17:03
     */
    public static void putItem(String key, Object item) {
        if (cache.get(key) != null) {
            cache.remove(key);
        }
        Element element = new Element(key, item);
        cache.put(element);
    }

    /**
     * 移除
     *
     * @param key
     * @Title: removeItem
     * @author: Omar(OmarZhang)
     * @date: 2016年7月22日 下午7:17:18
     */
    public static void removeItem(String key) {
        cache.remove(key);
    }

    /**
     * 更新
     *
     * @param key
     * @param value
     * @Title: updateItem
     * @author: Omar(OmarZhang)
     * @date: 2016年7月22日 下午7:17:26
     */
    public static void updateItem(String key, Object value) {
        putItem(key, value);
    }

    /**
     * 获取
     *
     * @param key
     * @return
     * @Title: getItem
     * @author: Omar(OmarZhang)
     * @date: 2016年7月22日 下午7:17:38
     */
    public static Object getItem(String key) {
        Element element = cache.get(key);
        if (null != element) {
            return element.getObjectValue();
        }
        return null;
    }

    /**
     * 获取长度
     *
     * @return
     * @Title: getLength
     * @author: Omar(OmarZhang)
     * @date: 2016年7月22日 下午7:18:35
     */
    public static Integer getLength() {
        return cache.getKeys().size();
    }

}
