package com.biz.eisp.activiti.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;

import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.StdSerializers;
import org.codehaus.jackson.type.TypeReference;

/**
 * json与pojo对象转换工具类
 *
 * @ClassName: JsonUtil
 * @Description:
 * @author Leowen
 * @date 2017年5月4日 下午2:37:35
 */
public class JsonUtil {

	private static JsonUtil jsonUtil;
	private ObjectMapper mapper;

	private JsonUtil(ObjectMapper mapper) {
		this.mapper = mapper;
	}

	private static JsonUtil getInstance() {
		if (jsonUtil == null) {
			ObjectMapper mapper = new ObjectMapper();
			SimpleModule module = new SimpleModule("JsonUtil", new Version(1,
					0, 0, null));
			module.addSerializer(new StdSerializers.LongSerializer());
//			module.addSerializer(new TimestampSerializer());
			mapper.registerModule(module);
			jsonUtil = new JsonUtil(mapper);
		}
		return jsonUtil;
	}

	private ObjectMapper getMapper() {
		return mapper;
	}

	public static <T> T jsonToObject(String json, Class<T> clazz)
			throws Exception {
		return getInstance().getMapper().readValue(json, clazz);
	}

	public static String toJson(Object value) throws Exception {
		return getInstance().getMapper().writeValueAsString(value);
	}

	public static <T> T covertValue(Object value, Class<T> toValueType)
			throws Exception {
		return getInstance().getMapper().convertValue(value, toValueType);
	}

	public static ArrayList<?> toObjectArrayListFromJson(String json,
														 TypeReference<?> t) throws JsonParseException,
			JsonMappingException, IOException {
		return (ArrayList<?>) getInstance().getMapper().readValue(json, t);
	}

	public static String filterJSONStr(String value) {
		String retStr = value;
		retStr = retStr.replace("\"", "\"").replace(",", ",");
		return retStr;
	}

	/**
	 * 得到格式化json数据 退格用\t 换行用\r
	 */
	public static String format(String jsonStr) {
		int level = 0;
		StringBuffer jsonForMatStr = new StringBuffer();
		for (int i = 0; i < jsonStr.length(); i++) {
			char c = jsonStr.charAt(i);
			if (level > 0
					&& '\n' == jsonForMatStr.charAt(jsonForMatStr.length() - 1)) {
				jsonForMatStr.append(getLevelStr(level));
			}
			switch (c) {
				case '{':
				case '[':
					jsonForMatStr.append(c + "\n");
					level++;
					break;
				case ',':
					jsonForMatStr.append(c + "\n");
					break;
				case '}':
				case ']':
					jsonForMatStr.append("\n");
					level--;
					jsonForMatStr.append(getLevelStr(level));
					jsonForMatStr.append(c);
					break;
				default:
					jsonForMatStr.append(c);
					break;
			}
		}

		return jsonForMatStr.toString();

	}

	private static String getLevelStr(int level) {
		StringBuffer levelStr = new StringBuffer();
		for (int levelI = 0; levelI < level; levelI++) {
			levelStr.append("\t");
		}
		return levelStr.toString();
	}

	/**
	 * method : fromJson2Maps
	 * description : 将JSON转换为List<Map<String,Object>>
	 * 一个MAP对应一条数据
	 * @param json
	 * @return
	 * author : User
	 * create date : 2016-6-17
	 */
	@SuppressWarnings("unchecked")
	public static List<Map<String,Object>> fromJson2Maps(String json){
		JSONArray jsonArray = JSONArray.fromObject(json);
		List<Map<String,Object>> jsonMapList = (List<Map<String,Object>>)jsonArray;
		return jsonMapList;
	}

}
