package com.biz.eisp.base.common.dao;

import java.util.List;

import com.biz.eisp.base.common.vo.TbAttachmentVo;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

/**
 * 附件功能Dao.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@InterfaceDao
public interface TbAttachmentDao {

	/**
	 * 查询附件列表.
	 * <p>
	 * 
	 * @param businessKey 业务主键id
	 * @param attachmentType 附件类型
	 * @return
	 */
	@ResultType(TbAttachmentVo.class)
	@Arguments({"businessKey","attachmentType"})
	public List<TbAttachmentVo> findTbAttachmentList(String businessKey, String attachmentType);

	@ResultType(TbAttachmentVo.class)
	@Arguments({"businessKey","attachmentType","positinoId"})
	public List<TbAttachmentVo> findTbAttachmentListByPositionCode(String businessKey, String attachmentType,String positinoId);
}
