package com.biz.eisp.base.common.identity;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import java.io.Serializable;

/**
 * UUID生成id
 * @author Sean
 *
 */
@MappedSuperclass
public abstract class IdEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	protected String id;

	@Id
	@GeneratedValue(generator = "paymentableGenerator")
	@GenericGenerator(name = "paymentableGenerator", strategy = "uuid")
	@Column(name ="ID",nullable=false,length=32)
	@NotFound(action= NotFoundAction.IGNORE)
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

}
