package com.biz.eisp.base.common.jsonmodel;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.vo.BaseVo;

/**
 * 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class AjaxJson {

    private boolean success = true;// 是否成功
    private String msg = "操作成功";// 提示信息
    private BaseVo vo = null;//vo对象信息
    private Map<String, Object> attributes;//其他参数
    private Object obj;
    private Integer type;
    private String flagId;//重复标记
    public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getFlagId() {
		return flagId;
	}

	public void setFlagId(String flagId) {
		this.flagId = flagId;
	}

	public AjaxJson() {
    	
    }
    
    /**
     * 操作成功
     * @param msg 操作成功提示信息
     */
    public AjaxJson(String msg) {
    	this.msg = msg;
    }
    
    /**
     * 操作成功
     * @param vo Vo对象信息
     */
    public AjaxJson(BaseVo vo) {
    	this.vo = vo;
    }
    
    /**
     * 操作成功
     * @param msg 操作成功提示信息
     * @param vo Vo对象信息
     */
    public AjaxJson(String msg, BaseVo vo) {
    	this.msg = msg;
    	this.vo = vo;
    }
    
    public Map<String, Object> getAttributes() { 
        return attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public BaseVo getVo() {
		return vo;
	}

	public void setVo(BaseVo vo) {
		this.vo = vo;
	}

	public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

	public String getJsonStr() {
        JSONObject obj = new JSONObject();
        obj.put("success", this.isSuccess());
        obj.put("msg", this.getMsg());
        obj.put("vo", this.vo);
        obj.put("attributes", this.attributes);
        return obj.toJSONString();
    }

	public Object getObj() {
		return obj;
	}

	public void setObj(Object obj) {
		this.obj = obj;
	}
	
}
