package com.biz.eisp.base.common.jsonmodel;

import java.util.List;

import com.biz.eisp.base.core.page.Page;

/**
 * EasyUi dataGrid返回实体，主要用于JSON返回。通过SpringMvc @ResponseBody返回此对象，转换成easyui
 * datagrid需要的格式数据
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public class DataGrid {

	private boolean success = true;
	private String pages; // 当前页
	private String total; // 总记录数
	private List rows;// 结果集
	private Object footer;// 合计列

	private String sort = null;// 排序字段名
	private String order = "ASC"; // 按什么排序(asc,desc)

	/**
	 * 构造DataGrid实体，返回easyui datagrid需要数据，与Spring Mvc（@ResponseBody）整合，返回Json格式数据
	 * @param rows datagrid列表数据
	 * @param page 页面对象
	 */
	public DataGrid(List rows, Page page) {
		this.rows = rows;
		if(page != null) {
			this.pages = page.get(Page.PAGE);
			this.total = page.get(Page.TOTAL);
		}
	}

	public boolean isSuccess() {
		return success;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}

	public String getPages() {
		return pages;
	}

	public void setPages(String pages) {
		this.pages = pages;
	}

	public String getTotal() {
		return total;
	}

	public void setTotal(String total) {
		this.total = total;
	}

	public List getRows() {
		return rows;
	}

	public void setRows(List rows) {
		this.rows = rows;
	}

	public Object getFooter() {
		return footer;
	}

	public void setFooter(Object footer) {
		this.footer = footer;
	}

	public String getSort() {
		return sort;
	}

	public void setSort(String sort) {
		this.sort = sort;
	}

	public String getOrder() {
		return order;
	}

	public void setOrder(String order) {
		this.order = order;
	}

}
