package com.biz.eisp.base.common.service;

import com.biz.eisp.base.core.service.BaseService;

/**
 * 附件管理扩展接口.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TbAttachmentExtendsService extends BaseService {

	/**
	 * 根据业务id，判断该业务的附件是否为只读状态.
	 * <p>
	 * 
	 * @param businessKey
	 * @return
	 */
	public boolean isReadOnly(String businessKey);

	/**
	 * 上传保存后置处理操作.
	 * <p>
	 * 
	 * @param businessKey
	 */
	public void savePostProcessor(String businessKey);

	/**
	 * 删除上传文件后置处理操作.
	 * <p>
	 * 
	 * @param businessKey
	 */
	public void deletePostProcessor(String businessKey);
}
