package com.biz.eisp.base.common.service;

import java.util.List;

import com.biz.eisp.base.common.vo.TbAttachmentVo;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 附件管理 Service.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
public interface TbAttachmentService extends BaseService {

	/**
	 * 根据业务key查询该业务的附件列表.
	 * <p>
	 * sql查询使用IN businessKey是一个值是直接传值无变化<p>
	 *     当值是多个时,第一个值前面的 ' 和最后一个只 后面的 ' 不用拼接<p>
	 * @param businessKey
	 * @return
	 */
	public List<TbAttachmentVo> findTbAttachmentList(String businessKey, String attachmentType);

	public List<TbAttachmentVo> findTbAttachmentList(String businessKey, String attachmentType,String positinoId);
	
	/**
	 * 删除文件.
	 * <p>
	 * 
	 * @param fileKey 业务key
	 * @param extendService 扩展Service
	 */
	public void deleteFile(String fileKey, String extendService);
}
