package com.biz.eisp.base.common.service;

import com.biz.eisp.base.common.vo.BaseVo;
import com.biz.eisp.base.core.service.BaseService;

import java.util.List;

/**
 * 活动核销工作流查看附件 service.
 *
 * @author huxm
 * @version v1.0
 */
public interface TtActAndAuditBillMainExtendService extends BaseService {
    /**
     * 获取业务数据的ID<p>
     * businessKey
     *
     * @param businessObjId
     * @author huxm
     */
    public String getBusinessKeyByBusinessObjId(String businessObjId);

    /**
     * 根据核销单ID获取活动主单据ID<p>
     * businessKey
     *
     * @param businessId
     * @author huxm
     */
    public String getBusinessKeyByTtAuditBillHeaderId(String businessId);


    /**
     * 根据核销单ID获取活动子单据ID<p>
     * businessKey
     *
     * @param businessKey
     * @author huxm
     */
    public List<BaseVo> findTtActByBusinessKey(String businessKey);
}
