package com.biz.eisp.base.common.service.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.base.common.dao.TbAttachmentDao;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.service.TbAttachmentService;
import com.biz.eisp.base.common.vo.TbAttachmentVo;
import com.biz.eisp.base.core.entity.TbAttachmentQueryEntity;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.ApplicationContextUtils;

/**
 * 附件管理 Service 实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("tbAttachmentService")
@Transactional
public class TbAttachmentServiceImpl extends BaseServiceImpl implements TbAttachmentService {

	@Autowired
	private TbAttachmentDao tbAttachmentDao;
	
	@Override
	public List<TbAttachmentVo> findTbAttachmentList(String businessKey, String attachmentType) {
		List <TbAttachmentVo> voList = tbAttachmentDao.findTbAttachmentList(businessKey, attachmentType);
		return voList;
	}
	public List<TbAttachmentVo> findTbAttachmentList(String businessKey, String attachmentType,String positinoId){
		List <TbAttachmentVo> list = tbAttachmentDao.findTbAttachmentListByPositionCode(businessKey, attachmentType,positinoId);
		return list;
	}
	@Override
	public void deleteFile(String fileKey, String extendService) {
		TbAttachmentQueryEntity attachment = this.get(TbAttachmentQueryEntity.class, fileKey);
		this.delete(attachment);
		
		//调用扩展删除接口
		if(StringUtils.isNotBlank(extendService)) {
			TbAttachmentExtendsService tbAttachmentExtendsService = ApplicationContextUtils
						.getContext().getBean(extendService, TbAttachmentExtendsService.class);
			tbAttachmentExtendsService.deletePostProcessor(fileKey);
		}
	}

}
