package com.biz.eisp.base.common.tag.bean;

/**
 * 列表字段模型
 * 
 * @author liukai
 *
 */
public class DataGridColumn implements Comparable {

	/**
	 * 表格列名
	 */
	protected String title;

	/**
	 * 数据库对应字段
	 */
	protected String field;

	/**
	 * 宽度
	 */
	protected Integer width;

	/**
	 * 跨列
	 */
	protected String rowspan;

	/**
	 * 跨行
	 */
	protected String colspan;

	/**
	 * 对齐方式
	 */
	protected String align;

	/**
	 * 是否排序
	 */
	protected boolean sortable;

	/**
	 * 是否显示复选框
	 */
	protected boolean checkbox;

	/**
	 * 格式化函数
	 */
	protected String formatter;

	/**
	 * 自定义函数名称(调用页面自定义js方法 参数为(value,row,index)
	 */
	protected String formatterjs;

	/**
	 * 是否隐藏
	 */
	protected boolean hidden;

	/**
	 * 
	 */
	protected String treefield;

	/**
	 * 是否是图片
	 */
	protected boolean image;

	/**
	 * 是否查询
	 */
	protected boolean query;

	/**
	 * 字段查询模式：single单字段查询；group范围查询
	 */
	protected String queryMode = "single";

	/**
	 * 列表是否自动加载数据
	 */
	protected boolean autoLoadData = true;

	/**
	 * 是否是冰冻列 默认不是
	 */
	private boolean frozenColumn = false;

	/**
	 * 自定义链接
	 */
	protected String url;

	/**
	 * 自定义函数名称
	 */
	protected String funname = "openwindow";

	/**
	 * 
	 */
	protected String arg;

	/**
	 * 
	 */
	protected String dictionary;

	/**
	 * 是否启用popup模式选择 默认不启用
	 */
	protected boolean popup = false;

	/**
	 * 
	 */
	protected String replace;

	/**
	 * 
	 */
	protected String extend;

	/**
	 * 列的颜色值
	 */
	protected String style;

	/**
	 * 自定义图片显示大小
	 */
	protected String imageSize;

	/**
	 * 附件下载
	 */
	protected String downloadName;

	/**
	 * 自动补全
	 */
	protected boolean autocomplete;

	/**
	 * 扩展参数,扩展easyui的参数
	 */
	protected String extendParams;

	/**
	 * 高级查询用的编辑器
	 */
	protected String editor;
	
	/** 显示顺序 */
	private Integer columnOrder;
	
	//主数据配置表单参数 表单类型
	private String formType;
	//主数据配置表单参数 表单远程请求数据 
	private String formUrl;
    private String methodname;//随机
    
    protected String hiddenName;
    protected String textname;// 显示文本框字段
    protected String left;
    protected String height;
    protected String hiddenid;// 隐藏框取值ID
    protected Boolean isclear = false;
    protected String inputTextname;
    protected String name;
	public String getEditor() {
		return editor;
	}

	public void setEditor(String editor) {
		this.editor = editor;
	}

	public String getDownloadName() {
		return downloadName;
	}

	public void setDownloadName(String downloadName) {
		this.downloadName = downloadName;
	}

	public String getImageSize() {
		return imageSize;
	}

	public void setImageSize(String imageSize) {
		this.imageSize = imageSize;
	}

	public boolean isQuery() {
		return query;
	}

	public String getArg() {
		return arg;
	}

	public void setArg(String arg) {
		this.arg = arg;
	}

	public void setQuery(boolean query) {
		this.query = query;
	}

	public boolean isImage() {
		return image;
	}

	public void setImage(boolean image) {
		this.image = image;
	}

	public String getTreefield() {
		return treefield;
	}

	public void setTreefield(String treefield) {
		this.treefield = treefield;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setField(String field) {
		this.field = field;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public void setRowspan(String rowspan) {
		this.rowspan = rowspan;
	}

	public void setColspan(String colspan) {
		this.colspan = colspan;
	}

	public void setAlign(String align) {
		this.align = align;
	}

	public void setSortable(boolean sortable) {
		this.sortable = sortable;
	}

	public void setCheckbox(boolean checkbox) {
		this.checkbox = checkbox;
	}

	public void setFormatter(String formatter) {
		this.formatter = formatter;
	}

	public boolean isHidden() {
		return hidden;
	}

	public void setHidden(boolean hidden) {
		this.hidden = hidden;
	}

	public String getTitle() {
		return title;
	}

	public String getField() {
		return field;
	}

	public Integer getWidth() {
		return width;
	}

	public String getRowspan() {
		return rowspan;
	}

	public String getColspan() {
		return colspan;
	}

	public String getAlign() {
		return align;
	}

	public boolean isSortable() {
		return sortable;
	}

	public boolean isCheckbox() {
		return checkbox;
	}

	public String getFormatter() {
		return formatter;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getFunname() {
		return funname;
	}

	public void setFunname(String funname) {
		this.funname = funname;
	}

	public String getDictionary() {
		return dictionary;
	}

	public void setDictionary(String dictionary) {
		this.dictionary = dictionary;
	}

	public boolean isPopup() {
		return popup;
	}

	public void setPopup(boolean popup) {
		this.popup = popup;
	}

	public String getQueryMode() {
		return queryMode;
	}

	public void setQueryMode(String queryMode) {
		this.queryMode = queryMode;
	}

	public String getReplace() {
		return replace;
	}

	public void setReplace(String replace) {
		this.replace = replace;
	}

	public boolean isAutoLoadData() {
		return autoLoadData;
	}

	public void setAutoLoadData(boolean autoLoadData) {
		this.autoLoadData = autoLoadData;
	}

	public boolean isFrozenColumn() {
		return frozenColumn;
	}

	public void setFrozenColumn(boolean frozenColumn) {
		this.frozenColumn = frozenColumn;
	}

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}

	public String getStyle() {
		return style;
	}

	public void setStyle(String style) {
		this.style = style;
	}

	public boolean isAutocomplete() {
		return autocomplete;
	}

	public void setAutocomplete(boolean autocomplete) {
		this.autocomplete = autocomplete;
	}

	public String getExtendParams() {
		return extendParams;
	}

	public void setExtendParams(String extendParams) {
		this.extendParams = extendParams;
	}

	public String getFormatterjs() {
		return formatterjs;
	}

	public void setFormatterjs(String formatterjs) {
		this.formatterjs = formatterjs;
	}

	public Integer getColumnOrder() {
		return columnOrder;
	}

	public void setColumnOrder(Integer columnOrder) {
		this.columnOrder = columnOrder;
	}

	public String getFormType() {
		return formType;
	}

	public String getFormUrl() {
		return formUrl;
	}

	public void setFormType(String formType) {
		this.formType = formType;
	}

	public void setFormUrl(String formUrl) {
		this.formUrl = formUrl;
	}
	
	//排序方法
	@Override
	public int compareTo(Object o) {
		if (o instanceof DataGridColumn) {
			DataGridColumn s = (DataGridColumn) o;
			if(s.getColumnOrder()!=null){
				if (this.columnOrder > s.getColumnOrder()) {
		            return (this.columnOrder -s.getColumnOrder());
		        }
			   if (this.columnOrder < s.getColumnOrder()) {
		            return (this.columnOrder - s.getColumnOrder());
		        }
			}
		}
		return 1;
	}

	public String getMethodname() {
		return methodname;
	}

	public void setMethodname(String methodname) {
		this.methodname = methodname;
	}

	public String getHiddenName() {
		return hiddenName;
	}

	public void setHiddenName(String hiddenName) {
		this.hiddenName = hiddenName;
	}

	public String getTextname() {
		return textname;
	}

	public void setTextname(String textname) {
		this.textname = textname;
	}

	public String getLeft() {
		return left;
	}

	public void setLeft(String left) {
		this.left = left;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getHiddenid() {
		return hiddenid;
	}

	public void setHiddenid(String hiddenid) {
		this.hiddenid = hiddenid;
	}

	public Boolean getIsclear() {
		return isclear;
	}

	public void setIsclear(Boolean isclear) {
		this.isclear = isclear;
	}

	public String getInputTextname() {
		return inputTextname;
	}

	public void setInputTextname(String inputTextname) {
		this.inputTextname = inputTextname;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}


}
