package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import com.biz.eisp.base.common.tag.params.CkeditorParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

/**
 * Ckeditor标签
 * @author Sean
 * @date 2016年9月29日
 * @version 1.0
 */
public class CkeditorTag extends TagSupport {

	private static final long serialVersionUID = 1L;
	protected String name;// 属性名称
	protected String value;// 默认值
	protected boolean isfinder;// 是否加载ckfinder(默认true)
	protected String type;// 其它属性(用法:height:400,uiColor:'#9AB8F3' 用,分割)

	public boolean isIsfinder() {
		return isfinder;
	}

	public void setIsfinder(boolean isfinder) {
		this.isfinder = isfinder;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	public int doEndTag() throws JspTagException {
		JspWriter out = null;
		try {
			out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				out.clear();
				out.close();
			} catch (Exception e2) {
			}
		}
		return EVAL_PAGE;
	}

	public String end() {
		CkeditorParams params=new CkeditorParams();	
		params.setIsfinder(isfinder);
		params.setName(name);
		params.setType(type);
		params.setValue(value);
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", params);
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/ckeditor.ftl", param);
		return content;
	}
}
