package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import com.biz.eisp.base.common.tag.params.ComboBoxParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;


/**
 * 可编辑的文本框和下拉列表
 * 
 * @author keith
 *
 */
public class ComboBoxTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	private String id;
    protected String value="value";// 值
    protected String text="text";// 显示文本
    protected String url;// 远程数据
    protected String name;// 控件名称
    protected Integer width;// 宽度
    protected Integer listWidth;// 下拉框宽度
    protected Integer listHeight;// 下拉框高度
    protected boolean editable;// 定义是否可以直接到文本域中键入文本
    protected boolean multiple = false; // 是否多选
    private boolean required=false;//是否必填
    private boolean isView=false;//是否只读
    private String defaultVal;//默认值 
    private String onSelectFun;//选中事件
    private String onChangeFun;//改变事件
    private String showValue;//显示value值
    private String showText="请手动设置显示值";//显示text值


	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	public int doEndTag() throws JspTagException {
		try {
			JspWriter out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public String end() {
        ComboBoxParams comboBoxParams = new ComboBoxParams();
        comboBoxParams.setId(id);
        comboBoxParams.setValue(value);
        comboBoxParams.setUrl(url);
        comboBoxParams.setEditable(editable);
        comboBoxParams.setListHeight(listHeight);
        comboBoxParams.setListWidth(listWidth);
        comboBoxParams.setMultiple(multiple);
        comboBoxParams.setName(name);
        comboBoxParams.setWidth(width);
        comboBoxParams.setText(text);
        comboBoxParams.setRequired(required);
        comboBoxParams.setDefaultVal(defaultVal);
        comboBoxParams.setOnSelectFun(onSelectFun);
        comboBoxParams.setOnSelectFun(onSelectFun);
        comboBoxParams.setOnChangeFun(onChangeFun);
        comboBoxParams.setIsView(isView);
        comboBoxParams.setShowValue(showValue);
        comboBoxParams.setShowText(showText);
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("param", comboBoxParams);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/ComboBox.ftl", param);
        return content;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getListWidth() {
        return listWidth;
    }

    public void setListWidth(Integer listWidth) {
        this.listWidth = listWidth;
    }

    public Integer getListHeight() {
        return listHeight;
    }

    public void setListHeight(Integer listHeight) {
        this.listHeight = listHeight;
    }

    public boolean isEditable() {
        return editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isMultiple() {
        return multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public boolean getRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public String getDefaultVal() {
		return defaultVal;
	}

	public void setDefaultVal(String defaultVal) {
		this.defaultVal = defaultVal;
	}

	public String getOnSelectFun() {
		return onSelectFun;
	}

	public void setOnSelectFun(String onSelectFun) {
		this.onSelectFun = onSelectFun;
	}

	public String getOnChangeFun() {
		return onChangeFun;
	}

	public void setOnChangeFun(String onChangeFun) {
		this.onChangeFun = onChangeFun;
	}

	public boolean getIsView() {
		return isView;
	}

	public void setIsView(boolean isView) {
		this.isView = isView;
	}

	public String getShowValue() {
		return showValue;
	}

	public void setShowValue(String showValue) {
		this.showValue = showValue;
	}

	public String getShowText() {
		return showText;
	}

	public void setShowText(String showText) {
		this.showText = showText;
	}
}
