package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import com.biz.eisp.base.common.tag.params.ComboTreeParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

/**
 * 组合树（combotree）把选择控件和下拉树结合起来
 * 
 * @author keith
 *
 */
public class ComboTreeTag extends TagSupport {
	private static final long serialVersionUID = 1L;

	protected String id;//id选择器
    protected String url;// 远程数据
    protected String name;// 控件名称
    protected String width;// 宽度
    protected String value;// 控件值
    protected String text;// 控件显示值
    private boolean multiple = false;// 是否多选
    private boolean required;//是否必填
    protected String onSelectFun;//onSelect事件方法



    public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	public int doEndTag() throws JspTagException {
		try {
			JspWriter out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public String end() {
        ComboTreeParams comboTreeParams = new ComboTreeParams();
        comboTreeParams.setName(name);
        comboTreeParams.setMultiple(multiple);
        comboTreeParams.setUrl(url);
        comboTreeParams.setValue(value);
        comboTreeParams.setWidth(width);
        comboTreeParams.setId(id);
        comboTreeParams.setRequired(required);
        comboTreeParams.setText(text);
        comboTreeParams.setOnSelectFun(onSelectFun);
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("param", comboTreeParams);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/ComboTree.ftl", param);
        return content;
    }

	/**
	 * getter url
	 * @return url
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * setter url   
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	public String getOnSelectFun() {
		return onSelectFun;
	}

	public void setOnSelectFun(String onSelectFun) {
		this.onSelectFun = onSelectFun;
	}

	/**
	 * getter name
	 * @return name
	 */
	public String getName() {
		return name;
	}

	/**
	 * setter name   
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * getter width
	 * @return width
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * setter width   
	 */
	public void setWidth(String width) {
		this.width = width;
	}

	/**
	 * getter value
	 * @return value
	 */
	public String getValue() {
		return value;
	}

	/**
	 * setter value   
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * getter multiple
	 * @return multiple
	 */
	public boolean isMultiple() {
		return multiple;
	}

	/**
	 * setter multiple   
	 */
	public void setMultiple(boolean multiple) {
		this.multiple = multiple;
	}

	/**
	 * getter id
	 * @return id
	 */
	public String getId() {
		return id;
	}

	/**
	 * setter id   
	 */
	public void setId(String id) {
		this.id = id;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}
}
