package com.biz.eisp.base.common.tag.tags;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * 列表自定义函数操作项处理标签
 * 
 * @author liukai
 *
 */
public class DataGridFunOptTag extends TagSupport {
	private static final long serialVersionUID = 1L;

	//列表操作标题
	protected String title;

	/**
	 * 判断链接是否显示的表达式
	 */
	private String exp;

	/**
	 * 自定义函数名称
	 */
	private String funname;

	/**
	 * 按钮的操作Code
	 */
	private String operationCode;

	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	@Override
	public int doEndTag() throws JspTagException {
		Tag t = findAncestorWithClass(this, DataGridTag.class);
		DataGridTag parent = (DataGridTag) t;
		parent.setFunUrl(title, exp, funname, operationCode);
		return EVAL_PAGE;
	}

	public void setFunname(String funname) {
		this.funname = funname;
	}

	public void setExp(String exp) {
		this.exp = exp;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setOperationCode(String operationCode) {
		this.operationCode = operationCode;
	}
}
