package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.common.tag.util.SelectExtend;
import com.biz.eisp.base.common.tag.util.StringReplace;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;

/**
 * 选择下拉框
 *
 * @author keith
 *
 */
public class DictSelectTag extends TagSupport {

    private static final long serialVersionUID = 1;
    private String typeGroupCode; // 数据字典类型
    private String field; // 选择表单的Name
    private String id; // 选择表单ID
    private String defaultVal; // 默认值
    private String divClass; // DIV样式
    private String labelClass; // Label样式
    private String title; // label显示值
    private boolean hasLabel = true; // 是否显示label
    private String type = "select";// 控件类型select|radio|checkbox
    private String dictTable;// 自定义字典表
    private String dictField;// 自定义字典表的匹配字段-字典的编码值
    private String dictText;// 自定义字典表的显示文本-字典的显示值
    private String extendJson;// 扩展参数
    private String dataType; // 表单验证规则
    private String ignore; // 是否忽略表单验证规则
    private String selectPrompt; // 使用选择框风格时的选择提示文字
    private String extend;//扩展
    private boolean isView;
    private Integer lineNum;//单选或复选框每个显示个数


	private BaseService baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
   
    @Override
    public int doStartTag() throws JspTagException {
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(end().toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }

    public StringBuffer end() {
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isBlank(divClass)) {
            divClass = "form"; // 默认form样式
        }
        if (StringUtils.isBlank(labelClass)) {
            labelClass = "Validform_label"; // 默认label样式
        }
        if(StringUtil.isNotEmpty(typeGroupCode)&&StringUtil.isEmpty(dictTable)){
        	 //查询数据字典
        	 List <TmDictDataEntity> dictDataList = baseService.
        			 findByProperty(TmDictDataEntity.class, "tmDictType.dictTypeCode", typeGroupCode);
        	 
        	 if ("radio".equals(type)) {
        		  for (int i =0;i< dictDataList.size();i++) {
                 	 TmDictDataEntity entity =dictDataList.get(i);
                 	 if(lineNum!=null&&lineNum!=0){
                 		 if(i%lineNum==0&&i>0){
                 			 sb.append("</br>");
                 		 }
                 	 }
                     radio(entity.getDictValue(),entity.getDictCode(), sb);
                 }
             } else if ("checkbox".equals(type)) {
                 for (int i =0;i< dictDataList.size();i++) {
                	 TmDictDataEntity entity =dictDataList.get(i);
                	 if(lineNum!=null&&lineNum!=0){
                		 if(i%lineNum==0&&i>0){
                			 sb.append("</br>");
                		 }
                	 }
                     checkbox(entity.getDictValue(), entity.getDictCode(), sb);
                 }
             } else if ("text".equals(type)) {
                 for (TmDictDataEntity entity : dictDataList) {
                     text(entity.getDictCode(), entity.getDictValue(), sb);
                 }
             } else {
            	 List mapList = new ArrayList();
                 
                 for(TmDictDataEntity entity : dictDataList) {
                 	Map <String, Object> map = new HashMap<String, Object>();
                 	map.put("TEXT", entity.getDictValue() );
                 	map.put("FIELD",entity.getDictCode());
                 	mapList.add(map);
                 }
                 select("--请选择--",mapList, sb);
             }
        	
        }else if (dictTable != null) {
            List<Map<String, Object>> list = queryDic();
            if ("radio".equals(type)) {
            	 for (int i=0;i<list.size();i++) {
                 	Map<String, Object> map=list.get(i);
                 	 if(lineNum!=null&&lineNum!=0){
                 		 if(i%lineNum==0&&i>0){
                 			 sb.append("</br>");
                 		 }
                 	 }
                    radio(map.get("text").toString(), map.get("field").toString(), sb);
                }
            } else if ("checkbox".equals(type)) {
                for (int i=0;i<list.size();i++) {
                	Map<String, Object> map=list.get(i);
                	 if(lineNum!=null&&lineNum!=0){
                		 if(i%lineNum==0&&i>0){
                			 sb.append("</br>");
                		 }
                	 }
                    checkbox(map.get("text").toString(), map.get("field").toString(), sb);
                }
            } else if ("text".equals(type)) {
                for (Map<String, Object> map : list) {
                    text(map.get("text").toString(), map.get("field").toString(), sb);
                }
            } else {
                select("--请选择--",list, sb);
            }
        }

        return sb;
    }


    /**
     * 文本框方法
     * 
     * @param name
     * @param code
     * @param sb
     */
    private void text(String name, String code, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> textMap = new HashMap<String, Object>();
        textMap.put("flag", "text");
        textMap.put("field", field);
        textMap.put("code", code);
        textMap.put("name", name);
        textMap.put("defaultVal", defaultVal);
        textMap.put("extend", extend);
        textMap.put("dataType", dataType);
        textMap.put("isView", isView);
        param.put("param", textMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    /**
     * 单选框方法
     * 
     * @author BIZ
     * 
     * @param name
     * @param code
     * @param sb
     */
    private void radio(String name, String code, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> radioMap = new HashMap<String, Object>();
        radioMap.put("flag", "radio");
        radioMap.put("field", field);
        radioMap.put("code", code);
        radioMap.put("dataType", dataType);
        radioMap.put("name", name);
        radioMap.put("defaultVal", defaultVal);
        radioMap.put("extend", extend);
        radioMap.put("dataType", dataType);
        radioMap.put("isView", isView);
        radioMap.put("lineNum", lineNum);
        param.put("param", radioMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    /**
     * 复选框方法
     * 
     * @作者：Alexander
     * 
     * @param name
     * @param code
     * @param sb
     */
    private void checkbox(String name, String code, StringBuffer sb) {

        String[] values = this.defaultVal.split(",");
        Boolean checked = false;
        for (int i = 0; i < values.length; i++) {
            String value = values[i];
            if (code.equals(value)) {
                checked = true;
                break;
            }
            checked = false;
        }

        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> checkboxMap = new HashMap<String, Object>();
        checkboxMap.put("flag", "checkbox");
        checkboxMap.put("field", field);
        checkboxMap.put("code", code);
        checkboxMap.put("id", id);
        checkboxMap.put("checked", checked);
        checkboxMap.put("name", name);
        checkboxMap.put("extend", extend);
        checkboxMap.put("dataType", dataType);
        checkboxMap.put("isView", isView);
        checkboxMap.put("lineNum", lineNum);
        param.put("param", checkboxMap);
        param.put("StringReplace", new StringReplace());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    /**
     * 选择框方法
     * @param map
     * @param sb
     */
    private void select(String name,List map, StringBuffer sb) {
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        Map<String, Object> selectMap = new HashMap<String, Object>();
        
        selectMap.put("flag", "select");
        selectMap.put("field", field);
        selectMap.put("extendJson", extendJson);
        selectMap.put("id", id);
        selectMap.put("dataType", dataType);
        selectMap.put("ignore", ignore);
        selectMap.put("map", map);
        selectMap.put("name", name);
        selectMap.put("defaultVal", defaultVal);
        selectMap.put("extend", extend);
        selectMap.put("isView", isView);
        param.put("param", selectMap);
        param.put("StringReplace", new StringReplace());
        param.put("SelectExtend", new SelectExtend());
        sb.append(freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/DictSelect.ftl", param));
    }

    /**
     * 查询自定义数据字典
     * 
     * @author BIZ
     */
    private List<Map<String, Object>> queryDic() {
        String sql = "select " + dictField + " as field," + dictText + " as text from " + dictTable;
        List<Map<String, Object>> list = baseService.findForMapList(sql);
        return list;
    }

    public String getTypeGroupCode() {
        return typeGroupCode;
    }

    public void setTypeGroupCode(String typeGroupCode) {
        this.typeGroupCode = typeGroupCode;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getDefaultVal() {
        return defaultVal;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    public String getDivClass() {
        return divClass;
    }

    public void setDivClass(String divClass) {
        this.divClass = divClass;
    }

    public String getLabelClass() {
        return labelClass;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isHasLabel() {
        return hasLabel;
    }

    public void setHasLabel(boolean hasLabel) {
        this.hasLabel = hasLabel;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDictTable() {
        return dictTable;
    }

    public void setDictTable(String dictTable) {
        this.dictTable = dictTable;
    }

    public String getDictField() {
        return dictField;
    }

    public void setDictField(String dictField) {
        this.dictField = dictField;
    }

    public String getDictText() {
        return dictText;
    }

    public void setDictText(String dictText) {
        this.dictText = dictText;
    }

    public String getExtendJson() {
        return extendJson;
    }

    public void setExtendJson(String extendJson) {
        this.extendJson = extendJson;
    }

    public String getDataType() {
        return dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getIgnore() {
        return ignore;
    }

    public void setIgnore(String ignore) {
        this.ignore = ignore;
    }

    public String getSelectPrompt() {
        return selectPrompt;
    }

    public void setSelectPrompt(String selectPrompt) {
        this.selectPrompt = selectPrompt;
    }

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}
    public boolean getIsView() {
		return isView;
	}

	public void setIsView(boolean isView) {
		this.isView = isView;
	}

	public Integer getLineNum() {
		return lineNum;
	}

	public void setLineNum(Integer lineNum) {
		this.lineNum = lineNum;
	}
	
}
