package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import com.biz.eisp.base.common.tag.params.FormMdmParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;

/**
 * 配置form 扩展
 * 
 * @author keith
 *
 */
public class FormMdmTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	
	//扩展字段表名  该字段不为空时 需要执行查询 获取表对应的扩展配置
	private String extendTableName;
	//传到页面的对象的名
	private String objName;
	// 0新增  1 修改  2查看
	private int optype;
	
    public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}
    
	public int doEndTag() throws JspTagException {
		try {
			JspWriter out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public String end() {
		//组建新form配置参数
		Object ob=this.pageContext.getRequest().getAttribute(objName);
		
		//构建动态表单信息
		List<FormMdmParams> paramsList= DynamicConfigUtil.getInstance().
				buildFormColumn(extendTableName, ob, optype);
		
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("param", paramsList);
        param.put("optype", optype);
        String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/cg/mdm.ftl", param);
        return content;
    }
	
	/**
	 *  getter extendTableName
	 *  @return extendTableName
	 */
	public String getExtendTableName() {
		return extendTableName;
	}

	/**
	 *  setter extendTableName   
	 * 
	 */
	public void setExtendTableName(String extendTableName) {
		this.extendTableName = extendTableName;
	}


	/**
	 *  getter objName
	 *  @return objName
	 */
	public String getObjName() {
		return objName;
	}


	/**
	 *  setter objName   
	 * 
	 */
	public void setObjName(String objName) {
		this.objName = objName;
	}

	/**
	 *  getter optype
	 *  @return optype
	 */
	public int getOptype() {
		return optype;
	}


	/**
	 *  setter optype   
	 * 
	 */
	public void setOptype(int optype) {
		this.optype = optype;
	}

   
}
