package com.biz.eisp.base.common.tag.tags;

import com.biz.eisp.base.utils.FreemarkerParseUtils;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * 表单验证
 * @author keith
 *
 */
public class FormValidationTag extends TagSupport {
    protected String formid = "formobj";// 表单FORM ID
    protected Boolean refresh = true;
    protected String callback;// 回调函数
    protected String beforeSubmit;// 提交前处理函数
    protected String btnsub = "btn_sub";// 以ID为标记触发提交事件
    protected String btnreset = "btn_reset";// 以ID为标记触发提交事件
    protected String layout = "div";// 表单布局
    protected String usePlugin;// 外调插件
    protected boolean dialog = true;// 是否是弹出窗口模式
    protected String action;// 表单提交路径
    protected String tabtitle;// 表单选项卡
    protected String tiptype = "4";// 校验方式



    @Override
    public int doStartTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
            Map<String, Object> param = new HashMap<String, Object>();
            Map<String, Object> formMap = new HashMap<String, Object>();
            //模板公用，标记区分
            formMap.put("flag", "start");
            formMap.put("layout", layout);
            formMap.put("action", action);
            formMap.put("formid", formid);
            formMap.put("btnsub", btnsub);
            formMap.put("dialog", dialog);
            param.put("param", formMap);
            String sb = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/FormValidation.ftl", param);
            out.print(sb);
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            String lang ="zh-cn";// (String) ((HttpServletRequest) this.pageContext.getRequest()).getSession().getAttribute("lang");

            JspWriter out = this.pageContext.getOut();

            FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
            Map<String, Object> param = new HashMap<String, Object>();
            Map<String, Object> formMap = new HashMap<String, Object>();
            //模板公用，标记区分
            formMap.put("flag", "end");
            formMap.put("layout", layout);
            formMap.put("tabtitle", tabtitle);
            formMap.put("lang", lang);
            formMap.put("usePlugin", usePlugin);
            formMap.put("formid", formid);
            formMap.put("tiptype", tiptype);
            formMap.put("btnsub", btnsub);
            formMap.put("btnreset", btnreset);
            formMap.put("beforeSubmit", beforeSubmit);
            formMap.put("dialog", dialog);
            formMap.put("callback", callback);
            formMap.put("refresh", refresh);
            param.put("param", formMap);
            String sb = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/FormValidation.ftl", param);
            out.print(sb.toString());
            out.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }

    public String getFormid() {
        return formid;
    }

    public void setFormid(String formid) {
        this.formid = formid;
    }

    public Boolean getRefresh() {
        return refresh;
    }

    public void setRefresh(Boolean refresh) {
        this.refresh = refresh;
    }

    public String getCallback() {
        return callback;
    }

    public void setCallback(String callback) {
        this.callback = callback;
    }

    public String getBeforeSubmit() {
        return beforeSubmit;
    }

    public void setBeforeSubmit(String beforeSubmit) {
        this.beforeSubmit = beforeSubmit;
    }

    public String getBtnsub() {
        return btnsub;
    }

    public void setBtnsub(String btnsub) {
        this.btnsub = btnsub;
    }

    public String getBtnreset() {
        return btnreset;
    }

    public void setBtnreset(String btnreset) {
        this.btnreset = btnreset;
    }

    public String getLayout() {
        return layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getUsePlugin() {
        return usePlugin;
    }

    public void setUsePlugin(String usePlugin) {
        this.usePlugin = usePlugin;
    }

    public boolean isDialog() {
        return dialog;
    }

    public void setDialog(boolean dialog) {
        this.dialog = dialog;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getTabtitle() {
        return tabtitle;
    }

    public void setTabtitle(String tabtitle) {
        this.tabtitle = tabtitle;
    }

    public String getTiptype() {
        return tiptype;
    }

    public void setTiptype(String tiptype) {
        this.tiptype = tiptype;
    }
}
