package com.biz.eisp.base.common.tag.tags;

import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;




/**
 * 动态菜单栏生成
 * 
 * @author BIZ
 * 
 */
public class ListtoMenu {

	/**
	 * @Description: TODO(拼装easyui树形html)  
	 * @param map
	 * @param style
	 * @return
	 */
	public static String newLeftStyle(Map<Integer, List<TmFunctionVo>> map, String style) {
    	if (map == null || map.size() == 0 || !map.containsKey(0)) {
    		return "不具有任何权限,\n\n请找管理员分配权限";
    	}
    	StringBuffer menuString = new StringBuffer();
    	List<TmFunctionVo> list = map.get(0);
    	if ("easyui".equals(style)) {
    		for (TmFunctionVo function : list) {
				menuString.append("<li>");
				String fname = function.getFunctionName();
				String icp = "";
				if (StringUtil.isNotEmpty(function.getIconPath())) {
					icp = function.getIconPath();
				}
				menuString.append("<a>")
						.append("<img src='" + icp + "'/>&nbsp;").append(fname)
						.append("</a><ul>");
				menuString.append(getChildOfTree(function, 1, map));
                menuString.append("</ul></li>");
    		}
    	}
    	return menuString.toString();
    }

	/**
     * 获取树形菜单
     * 
     * @param parent
     * @param level
     * @param map
     * @return
     */
    private static String getChildOfTree(TmFunctionVo parent, int level, Map<Integer, List<TmFunctionVo>> map) {
        StringBuffer menuString = new StringBuffer();
        if(!map.isEmpty()){
            List<TmFunctionVo> list = map.get(level);
            if(CollectionUtil.listNotEmptyNotSizeZero(list)){
                for (TmFunctionVo function : list) {
                    if (function.getParentId().equals(parent.getId())) {
                        if (function.getHaveLevel() == 0 || !map.containsKey(level + 1)) {

                            menuString.append(getLeafOfTree(function));

                        } else if (map.containsKey(level + 1)) {
                            if(StringUtil.isNotEmpty(function.getIconClas())){
                                menuString.append("<li state=\"closed\" iconCls=\"" + function.getIconClas()
                                        + "\" ><a>" + function.getFunctionName() + "</a>");
                            }else{
                                menuString.append("<li state=\"closed\" ><a>" + function.getFunctionName() + "</a>");
                            }

                            menuString.append("<ul >");
                            menuString.append(getChildOfTree(function, level + 1, map));
                            menuString.append("</ul></li>");
                        }
                    }
                }
            }
        }
        return menuString.toString();
    }
    
    /**
     * 获取叶子节点 ------树形菜单的叶子节点
     * 
     * @param function
     * @return
     */
    private static String getLeafOfTree(TmFunctionVo function) {
        StringBuffer menuString = new StringBuffer();
        String icon = "";
        if (StringUtil.isNotEmpty(function.getIconClas())) {
            icon = function.getIconClas();
        }
        menuString.append("<li iconCls=\"");
        menuString.append(icon);
        menuString.append("\"> <a onclick=\"addTab(\'");
        menuString.append(function.getFunctionName());
        menuString.append("\',\'");
        menuString.append(function.getFunctionUrl());
        if (function.getFunctionUrl().contains("?")) {
            menuString.append("&clickFunctionId=");
        } else {
            menuString.append("?clickFunctionId=");
        }
        menuString.append(function.getId());
        menuString.append("\',\'");
        menuString.append(icon);
        menuString.append("\')\"  title=\"");
        menuString.append(function.getFunctionName());
        menuString.append("\" url=\"");
        menuString.append(function.getFunctionUrl());
        menuString.append("\" href=\"javascript:;\" >");
        menuString.append(function.getFunctionName());
        menuString.append("</a></li>");
        return menuString.toString();
    }
}
