package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import com.biz.eisp.mdm.function.entity.TmFunctionEntity;
import com.biz.eisp.mdm.function.vo.TmFunctionVo;


/**
 * 
 * 类描述：菜单标签
 * 
 * Biz
 * 
 * @date： 日期：2012-12-7 时间：上午10:17:45
 * @version 1.0
 */
public class MenuTag extends TagSupport {
    private static final long serialVersionUID = 1L;
    protected String style = "easyui";// 菜单样式
    protected List<TmFunctionEntity> parentFun;// 一级菜单
    protected List<TmFunctionEntity> childFun;// 二级菜单
    protected Map<Integer, List<TmFunctionVo>> menuFun;// 菜单Map

    public void setParentFun(List<TmFunctionEntity> parentFun) {
        this.parentFun = parentFun;
    }

    public void setChildFun(List<TmFunctionEntity> childFun) {
        this.childFun = childFun;
    }

    @Override
    public int doStartTag() throws JspTagException {
        return EVAL_PAGE;
    }

    @Override
    public int doEndTag() throws JspTagException {
        try {
            JspWriter out = this.pageContext.getOut();
            out.print(end().toString());

        } catch (IOException e) {
            e.printStackTrace();
        }
        return EVAL_PAGE;
    }

    public StringBuffer end() {
        StringBuffer sb = new StringBuffer();
        if (style.equals("easyui")) {
            sb.append(ListtoMenu.newLeftStyle(menuFun, style));
//            FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
//            freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/menu.ftl", menuFun);
        }
        return sb;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setMenuFun(Map<Integer, List<TmFunctionVo>> menuFun) {
        this.menuFun = menuFun;
    }

}
