package com.biz.eisp.base.common.tag.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.util.StringUtils;

import com.biz.eisp.base.common.tag.params.UploadParams;
import com.biz.eisp.base.utils.FreemarkerParseUtils;

import oracle.net.aso.e;

/**
 * 上传标签
 * 
 * @author liukai
 *
 */
public class UploadTag extends TagSupport {
	private static final long serialVersionUID = 1L;
	
	/**
	 * ID
	 */
	protected String id;

	/**
	 * 上传的url地址
	 */
	protected String uploader;

	/**
	 * 控件名称
	 */
	protected String name;

	/**
	 * 参数名称
	 */
	protected String formData;

	/**
	 * 上传文件的扩展名
	 */
	protected String extend = "";

	/**
	 * 按钮文本
	 */
	protected String buttonText = "浏览";

	/**
	 * 是否多文件
	 */
	protected boolean multi = true;

	/**
	 * 文件容器ID
	 */
	protected String queueID = "filediv";

	/**
	 * 是否是弹出窗口模式
	 */
	protected boolean dialog = true;

	/**
	 * 
	 */
	protected String callback;

	/**
	 * 是否自动上传
	 */
	protected boolean auto = false;

	/**
	 * 上传成功处理函数
	 */
	protected String onUploadSuccess;

	/**
	 * 生成查看删除链接
	 */
	protected boolean view = false;

	/**
	 * 参数名称
	 */
	protected String formId;

	public String getFormId() {
		return formId;
	}

	public void setFormId(String formId) {
		this.formId = formId;
	}

	public void setView(boolean view) {
		this.view = view;
	}

	public void setOnUploadSuccess(String onUploadSuccess) {
		this.onUploadSuccess = onUploadSuccess;
	}

	public void setAuto(boolean auto) {
		this.auto = auto;
	}

	public void setCallback(String callback) {
		this.callback = callback;
	}

	public void setDialog(boolean dialog) {
		this.dialog = dialog;
	}

	public void setQueueID(String queueID) {
		this.queueID = queueID;
	}

	public void setButtonText(String buttonText) {
		this.buttonText = buttonText;
	}

	public void setMulti(boolean multi) {
		this.multi = multi;
	}

	public void setUploader(String uploader) {
		this.uploader = uploader;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Override
	public int doStartTag() throws JspTagException {
		return EVAL_PAGE;
	}

	@Override
	public int doEndTag() throws JspTagException {
		try {
			JspWriter out = this.pageContext.getOut();
			out.print(end());
			out.flush();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return EVAL_PAGE;
	}

	public String end() {
		UploadParams uploadParams = new UploadParams();
		uploadParams.setId(id);
		uploadParams.setAuto(String.valueOf(auto));
		uploadParams.setButtonText(buttonText);
		uploadParams.setCallback(callback);
		uploadParams.setDialog(String.valueOf(dialog));
		
		if("pic".equals(extend)){
			extend = "*.jpg;*.jpeg;*.png;*.gif;*.bmp;*.ico;*.tif";
		}
		if("office".equals(extend)){
			extend = "*.doc;*.docx;*.txt;*.ppt;*.pptx;*.xls;*.xlsx;*.html;*.htm";
		}
		if("picOffice".equals(extend)){
			extend = "*.jpg;*.jpeg;*.png;*.gif;*.bmp;*.ico;*.tif;*.doc;*.docx;*.txt;*.ppt;*.pptx;*.xls;*.xlsx;*.html;*.htm";
		}
        if("picOfficeZip".equals(extend)){
          	 extend = "*.jpg;*.jpeg;*.png;*.gif;*.bmp;*.ico;*.tif;*.doc;*.docx;*.txt;*.ppt;*.pptx;*.xls;*.xlsx;*.html;*.htm;*.rar;*.zip;*.tar;*.jar;*.iso;*.z;*.arj;*.gzip";
        }
        
		uploadParams.setExtend(extend);
		if(!StringUtils.isEmpty(formData)) {
			uploadParams.setFormData(StringUtils.commaDelimitedListToStringArray(formData));
		}
		uploadParams.setFormId(formId);
		uploadParams.setMulti(String.valueOf(multi));
		uploadParams.setName(name);
		uploadParams.setOnUploadSuccess(onUploadSuccess);
		uploadParams.setQueueID(queueID);
		uploadParams.setUploader(this.getUploader());
		uploadParams.setView(String.valueOf(view));
		
		
		
		
		
		FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
		
		Map <String, Object> param = new HashMap<String, Object>();
		param.put("param", uploadParams);
		
		String content = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/tag/ftl/upload.ftl", param);
		
		return content;
	}

	private String getUploader() {
		if (uploader.contains("?")) {
			return uploader + "&sessionId=" + pageContext.getSession().getId() + "";
		} else {
			return uploader + "?sessionId=" + pageContext.getSession().getId() + "";
		}
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}

	public void setFormData(String formData) {
		this.formData = formData;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}
}
