package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.org.util.TmOrgTreeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

@Component
public class ComboxTreeUtil implements Serializable {

	private static DBConfigUtil dbConfigUtil;

	@Autowired
	public static void setDbConfigUtil(DBConfigUtil dbConfigUtil) {
		ComboxTreeUtil.dbConfigUtil = dbConfigUtil;
	}

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
//	public final static String comboxTag=ResourceUtil.getDbConfigProperty("jdbc.username") +"_orgTree";
//	public final static String comboxTag_version=ResourceUtil.getDbConfigProperty("jdbc.username") +"_orgTree_version";
//	public final static String comboxTag=ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree";
//	public final static String comboxTag_version=ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree_version";
	public final static HashMap<String,Long> versionMap=new HashMap<>();
	public static  ConcurrentHashMap<String, List<ComboTree>> currMap=new ConcurrentHashMap<String, List<ComboTree>>();

	public static List<ComboTree> getComboTrees(){
		IRedisCacheService redisCacheService= RedisUtils.getIRedisCacheService();
		if (redisCacheService!=null) {
			Long now = redisCacheService.incrBy(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree_version", 0);//加0  获取当前的版本号
			Long old = ComboxTreeUtil.versionMap.get(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree_version");
			if (now.intValue() != old.intValue()) { //表示版本有更新
				ComboxTreeUtil.versionMap.put(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree_version",now); //更新本地版本
				try {
					List<ComboTree> orgVos=redisCacheService.getMapValues(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree",ComboTree.class);//获取所有 组织数据
					ComboxTreeUtil.currMap.put(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree", TmOrgTreeUtil.buildTree(orgVos));
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		List<ComboTree>  comboTrees=ComboxTreeUtil.currMap.get(ComboxTreeUtil.dbConfigUtil.getJdbcUserName() +"_orgTree");
		return comboTrees;
	}


	/**
	 * 获取当前对象树
	 * @param comboTrees
	 * @param comboTreeModel
	 * @param obj
	 * @return
	 */
	public static List<ComboTree> getComboxByObj(List<ComboTree> comboTrees,ComboTreeModel comboTreeModel,Object obj){
		List<ComboTree> trees=new ArrayList<ComboTree>();
		ReflectHelper reflectHelper = new ReflectHelper(obj);
		String id = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
		Set<String> tmpSet=new HashSet<String>();
		for (ComboTree ct : comboTrees) {
			ComboTree tmp=null;
			if (ct!=null&&ct.getId().equals(id)) {
				tmp=ct;
				if (!tmpSet.contains(tmp.getId())) {
				trees.add(tmp);
				tmpSet.add(tmp.getId());
				}
				break;
			}else{
				List<ComboTree> children=ct.getChildren();
				for (ComboTree chir : children) {
					tmp=sementTrees(chir,id);
					if (tmp!=null) {
						if (!tmpSet.contains(tmp.getId())) {
						trees.add(tmp);
						tmpSet.add(tmp.getId());
						}
						break;
					}
				}
			}
		}
		return trees;
	}
	/**
	 * 拆分树
	 */
	private static ComboTree sementTrees(ComboTree ct,String id){
		boolean b=false;
		ComboTree tmp=null;
		if (ct!=null&&ct.getId().equals(id)) {
				b=true;
				tmp= ct;
		}else{
			List<ComboTree> children=ct.getChildren();
			if(children!=null&&children.size()>0){
			   for (ComboTree comboTree : children) {
				 tmp=sementTrees(comboTree, id);
				 if (tmp!=null) {//如果找到就直接退出循环
					break;
				 }
			   }
			}else{
				tmp= null;
			}
		}
		  return tmp;
	}
}
