package com.biz.eisp.base.common.util;

import java.util.Map;
import java.util.Map.Entry;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.AfterFilter;

/** 
 *fastjson序列化特殊处理.
 * <p>在fastjson序列化之后添加内容
 * @author grover
 * @version v1.0
 */
public class FastJsonFilter extends AfterFilter {

	@SuppressWarnings("unchecked")
	@Override
	public void writeAfter(Object object) {
		JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(object));
		if (jsonObject.containsKey("fieldMap")) {
			String fieldMap = jsonObject.getString("fieldMap");
			if (StringUtil.isNotEmpty(fieldMap)) {
				Map<String, Object> fMap = JSON.parseObject(fieldMap, Map.class);
				if (StringUtil.isNotEmpty(fMap)) {
					for (Entry<String, Object> entry : fMap.entrySet()) {
						writeKeyValue("fieldMap." + entry.getKey(),entry.getValue());
					}
				}
			}
		}
	}

}
