package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DBTypeUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;


/**
 * 项目参数工具类
 */
public class ResourceUtil {

    private final static ResourceBundle rb = ResourceBundle.getBundle("dbconfig");
    private final static ResourceBundle rbsys = ResourceBundle.getBundle("sysconfig");

    /**
     * @param request
     * @return
     * @Description: TODO(获取请求方法)
     */
    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI() + "?" + request.getQueryString();
        if (requestPath.indexOf("&") > -1) {// 去掉其他参数
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);// 去掉项目路径
        return requestPath;
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    /**
     * 获取用户信息.
     *
     * @return 用户信息
     * @author grover
     */
    public static final TmUserEntity getSessionUserName() {
        Client client = getClient();
        if (client != null)
            return client.getUser();
        return null;
    }

    /**
     * 当前登录经销商信息
     *
     * @return
     */
    public static final TmCustomerEntity getSessionCustomer() {
        Client client = getClient();
        if (client != null)
            return client.getCustomerEntity();
        return null;
    }

    public static final TmPositionVo getCurrPosition() {
        Client client = getClient();
        if (client != null)
                return client.getPosition();
        return null;
    }

    public static final TmOrgEntity getCurrOrg() {
        Client client = getClient();
        if (client != null)
                return client.getOrg();
        return null;
    }

    public static final TmOrgEntity getCurrOrgByType(String orgType) {
        Client client = getClient();
        if (client != null) {
            if (client.getOrg() == null)
                return new TmOrgEntity();
            String currOrgId = client.getOrg().getId();
            TmOrgService tmOrgService = (TmOrgService) ApplicationContextUtils.getContext().getBean("tmOrgService");
            String sql = "select t.id from tm_org t where t.org_type = ?  start with t.id = ? connect by id = prior parent_id";
            List<Map<String, Object>> mapList = tmOrgService.findForMapList(sql, orgType, currOrgId);
            if (CollectionUtil.listNotEmptyNotSizeZero(mapList)) {
                return tmOrgService.get(TmOrgEntity.class, (String) mapList.get(0).get("id"));
            }
        }
        return new TmOrgEntity();
    }

    public static final TmCustomerOrgEntity getCurrCustomerOrg() {
        Client client = getClient();
        if (client != null)
            return client.getCustomerOrg();
        return null;
    }

    /**
     * 获取用户vo.
     * <p>包含职位 组织等
     *
     * @return
     * @author grover
     */
    public static TmUserVo getSessionTmUserVo() {
        TmUserService tmUserService = (TmUserService) ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUser(tmUserVo);
    }

    /**
     * 获取用户vo.
     * <p>包含职位 组织等
     *
     * @return
     * @author grover
     */
    public static List<TmUserVo> getSessionTmUserList() {
        TmUserService tmUserService = (TmUserService) ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUserList(tmUserVo);
    }

    /**
     * 获取当前登录人的权限角色编码集合 以,号分割.
     *
     * @return
     */
    public static final String getTmRoleString() {
        if (StringUtil.isNotEmpty(getCurrPosition())) {
            BaseService baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
            String positionId = getCurrPosition().getId();
            //角色字符串
            StringBuffer roleBuffer = new StringBuffer();
            //获取角色
            String sql = "SELECT TR.ROLE_NAME AS roleName,TR.ROLE_CODE AS roleCode,TR.ID AS id FROM TM_ROLE TR"
                    + " JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID "
                    + " WHERE TRPR.POSITION_ID = ?";
            List<TmRoleVo> tmRoleVos = baseService.findBySql(TmRoleVo.class, sql, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRoleVos)) {
                for (TmRoleVo tmRoleVo : tmRoleVos) {
                    if (roleBuffer.length() > 0) {
                        roleBuffer.append(",");
                    }
                    roleBuffer.append(tmRoleVo.getRoleCode());
                }
            }
            return roleBuffer.toString();
        }

        return null;
    }

    public static final String getCreateName() {
        Client client = getClient();
        if (client != null) {
            TmUserEntity user = client.getUser();
            TmPositionVo position = client.getPosition();
            if (user == null || position == null) {
                return null;
            }
            return user.getFullName() + "(" + position.getPositionName() + ")";
        }
        return null;
    }


    /**
     * 获取数据库类型
     *
     * @return
     * @throws Exception
     */
    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }



    /**
     * 获取sysconfig资源.
     *
     * @param propertyName 资源属性
     * @return 资源配置值
     * @author grover
     */
    public static final String getSysConfigProperty(String propertyName) {
        //返回值
        String value = null;
        //获取资源文件

        //读取值
        if (rbsys.containsKey(propertyName)) {
            value = rbsys.getString(propertyName);
        }
        return value;
    }
    /**
     * 获取dbconfig资源.
     *
     * @param propertyName 资源属性
     * @return 资源配置值
     * @author grover
     */
    public static final String getDbConfigProperty(String propertyName) {
        //返回值
        String value = null;
        //获取资源文件

        //读取值
        if (rb.containsKey(propertyName)) {
            value = rb.getString(propertyName);
        }
        return value;
    }

    public static Client getClient() {
        //获取客户设置的Client对象
        Client customerClient = CustomerClientHolder.getClient();
        if(customerClient != null) {
            //客户设置的Client对象，不会空则直接返回客户设置的对象
            return customerClient;
        }
        HttpSession session = ContextHolderUtils.getSession();
        String tokenstr=TokenUtil.getTokenStr(session);
        Client client = new Client();
        if (StringUtil.isNotEmpty(tokenstr)){
             client=TokenUtil.tokenMap.get(tokenstr);
        }else {
            Object ob = session.getAttribute(session.getId());
            try {
                if (ob != null) {
                    //client = JSONHelper.toBean(ob, Client.class);
                    client = (Client)ob;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    public static void setClient(Client client) {
        try {
                HttpSession session = ContextHolderUtils.getSession();
//                String jsonstr = JSONHelper.bean2json(client);
                //session.setAttribute(ContextHolderUtils.getSession().getId(), jsonstr);
            session.setAttribute(ContextHolderUtils.getSession().getId(), client);
        } catch (Exception e) {
            throw new BusinessException("登录认证缓存失败请重新尝试!");
        }
    }
    public static void setClient(Client client, IRedisCacheService redisCacheService) {
        try {
            HttpSession session = ContextHolderUtils.getSession();
            String tokenstr=TokenUtil.getTokenStr(session);
            if (StringUtil.isNotEmpty(tokenstr)){
                TokenUtil.saveTokenString(client,session,redisCacheService);
            }else {
                session.setAttribute(ContextHolderUtils.getSession().getId(), client);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("登录认证缓存失败请重新尝试!");
        }
    }
    /**
     * 设置键值
     *
     * @param key
     * @param value
     * @return
     */
    public static void addString(String key, String value) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute(key + session.getId(), value);
    }

    /**
     * 根据key获取值
     *
     * @param key
     * @return
     */
    public static String getString(String key) {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(key + session.getId());
        return ob != null ? ob.toString() : "";
    }

    public static Client getClientForLogin() {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        Client client = new Client();
        try {
            if (ob != null) {
                client =JSONHelper.toBean(ob,Client.class);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }
}
