package com.biz.eisp.base.common.util;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.utils.UUIDGenerator;
import com.biz.eisp.mdm.web.pojo.Client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
/**
 * ${DESCRIPTION}
 *
 * @author xuduan
 * @create 2018-01-12 下午3:07
 */

public class TokenUtil {
    /**
     * token认证
     */
    public static Map<String,Client> tokenMap=new ConcurrentHashMap();
    public static final String TOKEN_STRING_NAME = "TOKEN_STRING_NAME";

    //获取当前传回来的token
    public static String getTokenStr(HttpSession session) {
        Object obj = session.getAttribute(TOKEN_STRING_NAME);
        if (obj != null) {
            return obj.toString();
        } else {
            return "";
        }
    }

    /**
     * md5加密
     * @param token
     * @param userName
     * @return
     */
    public static  String tokenMd5(String token,String userName){
        if (StringUtil.isNotEmpty(userName)){
            token=userName+token;
        }
        String md5= Md5EncryptionAndDecryption.encryPwd(token);
        return md5;
    }
    public static void saveTokenString(Client client, HttpSession session,IRedisCacheService redisCacheService) throws Exception{
        String tokenStr = getTokenStr(session);
        if (redisCacheService!=null&&redisCacheService.checkAuto()){
            redisCacheService.set(tokenStr,client,client.getExpire());
        }else{
            tokenMap.put(tokenStr,client);
        }
    }
    public static String generateToken(String userId){
        return userId+new Long(System.currentTimeMillis()).toString();
    }
    /**
     *判断是否失效
     * @param token
     * @return
     */

    public static boolean isTokenStringValid(IRedisCacheService redisCacheService,String token) {
        boolean valid = false;
        if (redisCacheService!=null&&redisCacheService.checkAuto()) {
            Client client= getClient(redisCacheService,token);
            if (client!=null) {
                valid = true;
                tokenMap.put(token,client);
            }
        }else{
            if(tokenMap.containsKey(token)){
                    valid = true;
            }
        }
        return valid;
    }
    /**
     * 移除token
     * @param session
     */
    public static  void removeToken(IRedisCacheService redisCacheService, HttpSession session) throws Exception{
        String tokenStr=getTokenStr(session);
        if (redisCacheService!=null&&redisCacheService.checkAuto()) {
                redisCacheService.remove(tokenStr);
                tokenMap.remove(tokenStr);
        }else{
            tokenMap.remove(tokenStr);
        }
    }
    public static Client getClient(IRedisCacheService redisCacheService,String token){
        Client client=null;
        try {
            client = redisCacheService.get(token, Client.class);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return client;
    }
}

