package com.biz.eisp.base.common.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;

import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.vo.TreeGridVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;

/** 
 * treeGrid处理类
 * @author wuzhujun
 * @version v1.0
 */
public class TreeGridUtil {
	/**
	 * 构建树形结构
	 * @author wuzhujun
	 * @param treegrids
	 * @return 返回treeGrid一颗树
	 */
	public static List<TreeGrid> buildTree(List<TreeGrid> treegrids) {
		
		List<TreeGrid> results = new ArrayList<TreeGrid>();
		//1.把所有节点方程id 对象键值对的形式存储在一个map当中
		Map<String, TreeGrid> aidMap = new LinkedHashMap<String, TreeGrid>();
		for (TreeGrid node : treegrids) {
			aidMap.put(node.getId(), node);
		}
		treegrids = null;

		Set<Entry<String, TreeGrid>> entrySet = aidMap.entrySet();
		for (Entry<String, TreeGrid> entry : entrySet) {
			String pid = entry.getValue().getParentId();
			TreeGrid node = aidMap.get(pid);
			if (node == null) {
				results.add(entry.getValue());
			} else {
				List<TreeGrid> children = node.getChildren();
				if (children == null) {
					children = new ArrayList<TreeGrid>();
					node.setChildren(children);
				}
				children.add(entry.getValue());
			}
		}
		aidMap = null;
		setOpen(results);
		return results;
	}
	
	/**
	 * 构建完整的TreeGrid树.
	 * <p>
	 * @param treeGridVoList
	 * @return
	 */
	public static List buildTreeGrid(List treeGridVoList) {
		List resultList = new ArrayList();
		
		Map <String, Object> keyMap = new LinkedHashMap<String, Object>(); 
		
		//把所有节点方程id 对象键值对的形式存储在一个map当中
		for(int i = 0; treeGridVoList != null && i < treeGridVoList.size(); i++){
			ReflectHelper treeGridVo = new ReflectHelper(treeGridVoList.get(i));
			String id = (String)treeGridVo.getMethodValue("id");
			keyMap.put(id, treeGridVoList.get(i));
		}
		
		Object node = null;
		for(int i = 0; treeGridVoList != null && i < treeGridVoList.size(); i++){
			node = treeGridVoList.get(i);
			ReflectHelper nodeReflect = new ReflectHelper(node);
			String parentId = (String)nodeReflect.getMethodValue("parentId");
			if(StringUtils.isNotBlank(parentId)) {
				Object parentNode = keyMap.get(parentId);
				ReflectHelper parentNodeReflect = new ReflectHelper(parentNode);
				List children = (List)parentNodeReflect.getMethodValue("children");
				if(children == null) {
					parentNodeReflect.setMethodValue("children", new ArrayList());
					children = (List)parentNodeReflect.getMethodValue("children");
				}
				children.add(node);
			} else {
				resultList.add(node);
			}
		}
		
		return resultList;
	}
	
	/**
	 * 递归判断是否有子节点设置节点属性为展开
	 * @author wuzhujun
	 * @param list
	 */
	public static void setOpen(List<TreeGrid> list){
		for(TreeGrid t:list){
			if(t.getChildren()!=null){
				t.setState("open");
				setOpen(t.getChildren());
			}
		}
	}
}
