package com.biz.eisp.base.common.util.json;

import java.util.HashMap;

public class HttpStatusCode {
	
	private static HashMap<Integer, String> map = new HashMap<Integer,String>();
	
	public static final int NOT_FOUNT = 404;   
	public static final int SERVER_ERROR = 500;
	public static final int SERVER_OP_SUCCESS = 2000;
	public static final int REQUEST_PARAMS_MUST_NOT_NULL = 1001;
	public static final int INVOK_MENTHOD_MUST_NOT_NULL = 1002;
	public static final int CLASSNAME_MUST_NOT_NULL = 1003;
	public static final int JSON_MAPPING_EXCEPTION=1004;
	public static final int JSON_PARSE_EXCEPTION = 1005;
	public static final int IO_EXCEPTION = 1006;
	public static final int CLASS_NOT_FOUND_EXCEPTION=1007;
	public static final int INSTANTIATION_EXCEPTION = 1008;
	public static final int ILLEGAL_ACCESS_EXCEPTION = 1009;
	public static final int NO_SUCH_METHOD_EXCEPTION=1010;
	public static final int ILLEGAL_ARGUMENT_EXCEPTION= 1011;
	public static final int INVOCATION_TARGET_EXCEPTION=1012;
	public static final int INVOK_MENTHOD_ARGUMENT_MUST_NOT_NULL=1013;
	
	public static String getMessage(int code){
		return map.get(code);
	}
	
	static{
		map.put(SERVER_OP_SUCCESS, "服务端处理成功!");
		map.put(NOT_FOUNT, "未找到相应资源");
		map.put(SERVER_ERROR, "服务端内部错误");
		map.put(REQUEST_PARAMS_MUST_NOT_NULL, "请求参数不能为空");
		map.put(INVOK_MENTHOD_MUST_NOT_NULL, "调用方法不能为空");
		map.put(INVOK_MENTHOD_ARGUMENT_MUST_NOT_NULL, "参数不能为空");
		map.put(CLASSNAME_MUST_NOT_NULL, "类名称不能为空");
		map.put(JSON_MAPPING_EXCEPTION, "JSON对象转换异常");
		map.put(JSON_PARSE_EXCEPTION, "JSON解析转换异常");
		map.put(IO_EXCEPTION, "程序I/O异常");
		map.put(CLASS_NOT_FOUND_EXCEPTION, "未找到对应的处理类");
		map.put(CLASS_NOT_FOUND_EXCEPTION, "对象实例化异常");
		map.put(ILLEGAL_ACCESS_EXCEPTION, "非法访问异常");
		map.put(NO_SUCH_METHOD_EXCEPTION, "调用方法不存在");
		map.put(ILLEGAL_ARGUMENT_EXCEPTION, "非法参数");
		map.put(INVOCATION_TARGET_EXCEPTION, "调用目标方法异常");
	} 
	
	
}
