package com.biz.eisp.base.common.web;


import com.biz.eisp.activiti.runtime.entity.TaAttachmentEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.service.TbAttachmentService;
import com.biz.eisp.base.common.service.TtActAndAuditBillMainExtendService;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.common.vo.BaseVo;
import com.biz.eisp.base.common.vo.TbAttachmentVo;
import com.biz.eisp.base.core.entity.TbAttachmentEntity;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.MyClassLoader;
import com.biz.eisp.base.utils.UploadFile;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 附件管理Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/tbAttachmentController")
public class TbAttachmentController extends BaseController {

	@Autowired
	private TbAttachmentService tbAttachmentService;
	@Autowired
	private TaTaskService taTaskService;
	@Autowired
	private TaskService taskService;

	@Autowired(required = false)
	private TtActAndAuditBillMainExtendService ttActAndAuditBillMainExtendService;

	private TbAttachmentExtendsService tbAttachmentExtendsService;

	/**
	 * 跳转至附件主页面.
	 * <p>
	 * 
	 * @param id
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goTbAttachmentMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTbAttachmentMain(String id, String extendService, String attachmentType,
			HttpServletRequest request) {
		if (StringUtils.isNotBlank(extendService)) {
			tbAttachmentExtendsService = ApplicationContextUtils.getContext().getBean(extendService,
					TbAttachmentExtendsService.class);
			boolean isReadOnly = tbAttachmentExtendsService.isReadOnly(id);
			request.setAttribute("isReadOnly", isReadOnly);
		}

		List<TbAttachmentVo> voList = tbAttachmentService.findTbAttachmentList(id, attachmentType);
		request.setAttribute("voList", voList);
		request.setAttribute("businessKey", id);
		request.setAttribute("attachmentType", attachmentType);
		request.setAttribute("extendService", extendService);
		String extend=request.getParameter("extend");
		if(StringUtil.isEmpty(extend)){
			extend="*.*";
		}
		request.setAttribute("extend", extend);
		return new ModelAndView("com/biz/eisp/base/tbAttachmentMain");
	}

	/**
	 * 保存附件.
	 * <p>
	 * 
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "saveFiles", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveFiles(String extendService, HttpServletRequest request, HttpServletResponse response) {
		AjaxJson j = new AjaxJson();

		try {
			String businessKey = request.getParameter("businessKey");
			String attachmentType = request.getParameter("attachmentType");
			TbAttachmentEntity entity = new TbAttachmentEntity();
			entity.setBusinessKey(businessKey);
			String positionId = ResourceConfigUtils.getCurrPosition().getId();
			TmPositionEntity positionEntity = tbAttachmentService.get(TmPositionEntity.class, positionId);
			entity.setTmPositionEntity(positionEntity);
			entity.setSubclassName(TaAttachmentEntity.class.getName());
			entity.setAttachmentType(attachmentType);
			UploadFile uploadFile = new UploadFile(request, entity);
//			uploadFile.setCusPath("resources/upload");  //默认按照时间来处理
			uploadFile.setExtend("extend");
			uploadFile.setTitleField("attachmentTitle");
			uploadFile.setRealPath("realPath");
			uploadFile.setObject(entity);
			uploadFile.setRename(true);

			tbAttachmentService.uploadFile(uploadFile, extendService, businessKey);

			List<TbAttachmentVo> myAttachmentList = tbAttachmentService.findTbAttachmentList(businessKey,
					attachmentType);
			Map<String, Object> attributes = new HashMap<String, Object>();
			attributes.put("url", entity.getRealPath());
			attributes.put("fileKey", entity.getId());
			attributes.put("name", entity.getAttachmentTitle());
			attributes.put("delurl", "tbAttachmentController.do?delObjFile&fileKey=" + entity.getId());
			attributes.put("myAttachmentList", myAttachmentList);
			attributes.put("id", entity.getId());
			j.setAttributes(attributes);
			j.setMsg("文件添加成功");
		} catch (Exception e) {
			e.printStackTrace();
		}

		return j;
	}

	/**
	 * 删除文件.
	 * <p>
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "delObjFile", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delObjFile(HttpServletRequest request, String extendService, String fileKey) {
		String message = null;
		AjaxJson j = new AjaxJson();
		try {
			tbAttachmentService.deleteFile(fileKey, extendService);
			message = "删除成功";
			j.setSuccess(true);
		} catch (Exception e) {
			e.printStackTrace();
			j.setMsg("删除失败");
			j.setSuccess(false);
		}
		j.setMsg(message);
		return j;
	}

	/**
	 * 查询文件.
	 * <p>
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "viewFile", method = {RequestMethod.GET, RequestMethod.POST})
	public void viewFile(HttpServletRequest request, HttpServletResponse response) {
		String fileid = OConvertUtils.getString(request.getParameter("fileid"));
		String subclassname = OConvertUtils.getString(request.getParameter("subclassName"),
				"com.biz.eisp.base.core.entity.TbAttachmentQueryEntity");
		Class fileClass = MyClassLoader.getClassByScn(subclassname);// 附件的实际类
		Object fileobj = tbAttachmentService.get(fileClass, fileid);
		ReflectHelper reflectHelper = new ReflectHelper(fileobj);
		UploadFile uploadFile = new UploadFile(request, response);
		String contentfield = OConvertUtils.getString(request.getParameter("contentfield"), uploadFile.getByteField());
		byte[] content = (byte[]) reflectHelper.getMethodValue(contentfield);
		String path = OConvertUtils.getString(reflectHelper.getMethodValue("realPath"));
		String extend = OConvertUtils.getString(reflectHelper.getMethodValue("extend"));
		String attachmenttitle = OConvertUtils.getString(reflectHelper.getMethodValue("attachmentTitle"));
		uploadFile.setExtend(extend);
		uploadFile.setTitleField(attachmenttitle);
		uploadFile.setRealPath(path);
		uploadFile.setContent(content);
		// uploadFile.setView(true);
		tbAttachmentService.viewOrDownloadFile(uploadFile);
	}

	@RequestMapping(value = "findAttachmentList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findAttachmentList(String businessKey, String attachmentType, HttpServletRequest request,
			HttpServletResponse response) {
		List<TbAttachmentVo> voList = tbAttachmentService.findTbAttachmentList(businessKey, attachmentType);
		return new DataGrid(voList, null);
	}


	/**
	 * 跳转至附件主页面 - 工作流查看附件数据.
	 * <p>
	 *
	 * @param taskId
	 * @param processInstanceId
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goTbAttachmentWorkFlowMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTbAttachmentWorkFlowMain(String taskId, String processInstanceId, String extendService, String attachmentType,
												   HttpServletRequest request) {
		ModelAndView view = new ModelAndView("com/biz/eisp/base/tbAttachmentMain");

		String businessObjId = null;
		String businessKey = null;
		if (StringUtil.isNotEmpty(taskId)) {
			Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
			businessObjId = taTaskService.getBusinessObjIdByTask(task);
		} else {
			BusinessFormVo vo = taTaskService.getBusinessFormByProcessInstanceId(processInstanceId);
			businessObjId = vo.getBusinessObjId();
		}
		businessKey = ttActAndAuditBillMainExtendService.getBusinessKeyByBusinessObjId(businessObjId);
		if (StringUtil.isNotEmpty(businessKey)) {
			String businessId = ttActAndAuditBillMainExtendService.getBusinessKeyByTtAuditBillHeaderId(businessKey);
			if (StringUtil.isNotEmpty(businessId)) {
				List<BaseVo> actIdList = ttActAndAuditBillMainExtendService.findTtActByBusinessKey(businessKey);
				if (CollectionUtil.listNotEmpty(actIdList)) {
					for (BaseVo actId : actIdList) {
						businessKey += "','" + actId.getId();
					}
				}
				businessKey += "','" + businessId;
			}

		}

		if (StringUtil.isEmpty(businessKey)) {
			//未找到businessKey  无附件  将businessKey赋值未其他
			businessKey = "2017年6月28日16:30:22";
		}
		view.addObject("voList", "");
		//传入businessKey 如果businessKey 为空 ,界面回加载所有的附件!
		view.addObject("businessKey", businessKey);
		view.addObject("attachmentType", attachmentType);
		view.addObject("extendService", extendService);
		//附近只可读
		view.addObject("isReadOnly", true);
		return view;
	}
}
