package com.biz.eisp.base.core.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

/**
 * 附件父表 查询Entity 只用于查询，避免进行连接查询功能.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "tb_attachment")
public class TbAttachmentQueryEntity extends IdEntity implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private TmPositionEntity tmPositionEntity;// 创建职位
	private String businessKey;// 业务类主键
	private String subclassName;// 子类名称全路径
	private String attachmentTitle;// 附件名称
	private byte[] attachmentContent;// 附件内容
	private String realPath;// 附件物理路径
	private Date createDate;
	private String note;
	private String swfPath;// swf格式路径
	private String extend;// 扩展名

	@Column(name = "extend", length = 32)
	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "position_id")
	public TmPositionEntity getTmPositionEntity() {
		return tmPositionEntity;
	}

	public void setTmPositionEntity(TmPositionEntity tmPositionEntity) {
		this.tmPositionEntity = tmPositionEntity;
	}

	@Column(name = "business_key", length = 32)
	public String getBusinessKey() {
		return businessKey;
	}

	public void setBusinessKey(String businessKey) {
		this.businessKey = businessKey;
	}

	@Column(name = "attachment_title", length = 100)
	public String getAttachmentTitle() {
		return this.attachmentTitle;
	}

	public void setAttachmentTitle(String attachmentTitle) {
		this.attachmentTitle = attachmentTitle;
	}

	@Column(name = "attachment_content", length = 3000)
	@Lob
	public byte[] getAttachmentContent() {
		return this.attachmentContent;
	}

	public void setAttachmentContent(byte[] attachmentContent) {
		this.attachmentContent = attachmentContent;
	}

	@Column(name = "real_path", length = 100)
	public String getRealPath() {
		return this.realPath;
	}

	public void setRealPath(String realPath) {
		this.realPath = realPath;
	}

	@Column(name = "create_date")
	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	@Column(name = "note", length = 300)
	public String getNote() {
		return this.note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	@Column(name = "swf_path", length = 300)
	public String getSwfPath() {
		return this.swfPath;
	}

	public void setSwfPath(String swfPath) {
		this.swfPath = swfPath;
	}

	@Column(name = "subclass_name", length = 300)
	public String getSubclassName() {
		return subclassName;
	}

	public void setSubclassName(String subclassName) {
		this.subclassName = subclassName;
	}

}
