package com.biz.eisp.base.core.interceptors;

import java.io.Serializable;
import java.util.Date;

import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.springframework.stereotype.Component;

import com.biz.eisp.base.common.constant.HibernateConstant;
import com.biz.eisp.mdm.authobj.util.AuthObjHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * Hiberate拦截器：实现创建人，创建时间，创建人名称自动注入; 修改人,修改时间,修改人名自动注入;
 *
 * @author liukai
 *
 */
@Component
public class HibernateEntityInterceptor extends EmptyInterceptor {

	private static final long serialVersionUID = 1L;

	@Override
	public boolean onSave(Object entity, Serializable id, Object[] state,
						  String[] propertyNames, Type[] types) {
		for(int i = 0 ;i < propertyNames.length; i++) {
			//设置创建时间
			if (HibernateConstant.CREATE_DATE.equals(propertyNames[i])) {
				if(isEmpty(state[i])){
					state[i] = new Date();
				}
				continue;
			}
			//设置创建用户账号
			else if (HibernateConstant.CREATE_NAME.equals(propertyNames[i])) {
				if(isEmpty(state[i])) {
					state[i] = ResourceConfigUtils.getCreateName();
				}
				continue;
			}
			//设置修改时间
			else if (HibernateConstant.UPDATE_DATE.equals(propertyNames[i])) {
				if(isEmpty(state[i])) {
					state[i] = new Date();
				}
				continue;
			}
			//设置修改用户账号
			else if (HibernateConstant.UPDATE_NAME.equals(propertyNames[i])) {
				if(isEmpty(state[i])) {
					state[i] = ResourceConfigUtils.getCreateName();
				}
				continue;
			}
			//设置创建用户主职位id
			else if (HibernateConstant.CREATE_POS_ID.equals(propertyNames[i])) {
				if(isEmpty(state[i])) {
					state[i] = ResourceConfigUtils.getCurrPosition().getId();
				}
				continue;
			}
		}
		return true;
	}
	private boolean checkSession(){
		boolean b=true;
		HttpServletRequest request=ContextHolderUtils.getRequest();
		if (request==null){
			b=false;
		}else{
			HttpSession session = request.getSession();
			if (session==null){
				b=false;
			}
		}
		return b;
	}
	@Override
	public boolean onFlushDirty(Object entity,Serializable id,  Object[] currentState,
								Object[] previousState, String[] propertyNames,Type[] types) {

		for(int i=0;i<propertyNames.length;i++){
			//设置修改时间
			if (HibernateConstant.UPDATE_DATE.equals(propertyNames[i])) {
				currentState[i] = new Date();
				continue;
			}
			//设置修改用户
			else if (HibernateConstant.UPDATE_NAME.equals(propertyNames[i])) {
				if (checkSession()){  //表示session存在
					currentState[i] = ResourceConfigUtils.getCreateName();
				}else{  //如果不存在session  那么直接 判断字段是否有值  如果有那么使用此值
					if(isEmpty(propertyNames[i])) {
						currentState[i] = ResourceConfigUtils.getCreateName();
					}
				}
				continue;
			}
			//设置修改人主职位id
			else if (HibernateConstant.UPDATE_POS_ID.equals(propertyNames[i])) {
				if (checkSession()) {  //表示session存在
					currentState[i] = ResourceConfigUtils.getCurrPosition().getId();
				}else {//如果不存在session  那么直接 判断字段是否有值  如果有那么使用此值
					if (isEmpty(propertyNames[i])) {
						currentState[i] = ResourceConfigUtils.getCurrPosition().getId();
					}
				}
				continue;
			}
		}
		return true;
	}

	/**
	 * 判断object是否为空
	 * @param object
	 * @return
	 */
	public boolean isEmpty(Object object) {
		if (object == null||object.equals("")||object.equals("null")) {
			return (true);
		}
		return (false);
	}

	@Override
	public String onPrepareStatement(String sql) {
		//权限对象判定
		return AuthObjHandler.executeAuthHandle(sql);
	}

}

