package com.biz.eisp.base.core.interceptors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;

/**
 * <p>页面对象拦截器</p>
 * 拦截页面数据，通过request对象构建Page对象<br>
 * 把构建好的Page对象，绑定到ThreadLocal当前线程中，注意：ThreadLocal是请求级别的，它会贯穿整个页面请求（即：Controller，Service，Dao三层）<br>
 * @author liukai
 *
 */
public class PageInterceptor implements HandlerInterceptor {

	/**
	 * 创建当前线程，用于绑定Page对象
	 */
	private static final ThreadLocal <Page> contextHolder = new ThreadLocal<Page>();
	
	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		//构建Page对象，构建EuPage对象
		Page page = new EuPage(request);
		
		//绑定到contextHolder
		contextHolder.set(page);
		
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
			ModelAndView modelAndView) throws Exception {
		//不做处理
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
			Object handler, Exception ex)
			throws Exception {
		//不做处理
	}
	
	/**
	 * 获取Page对象
	 * @return
	 */
	public static Page getPage(){
		return (Page) contextHolder.get();
	}

}
