package com.biz.eisp.base.core.redis.aop;


import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

import com.biz.eisp.base.core.redis.annotation.DeleteThroughAssignCache;
import com.biz.eisp.base.core.redis.annotation.ReadCacheType;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;


abstract class SingleDeleteCacheAdvice extends CacheAdvice {

	@Autowired
	private IRedisCacheService redisCacheService;
	
    protected Object delete(final ProceedingJoinPoint pjp) throws Throwable {
    	//验证 缓存 是否开启
        if ( isEnable()) {
            getLogger().info("Cache disabled");
            return pjp.proceed();
        }
        
        Method method = getMethod(pjp);
        DeleteThroughAssignCache cacheable=method.getAnnotation(DeleteThroughAssignCache.class);
        
        final Signature sig = pjp.getSignature();
        final MethodSignature msig = (MethodSignature) sig;
        
        //验证 方法缓存是否开启
        if(cacheable != null && cacheable.cacheEnable()){
        	// 获取 KEY规则
        	String namespace =  cacheable.namespace();
        	String assignedKey =  cacheable.assignedKey();
        	
        	Annotation [][] anns = method.getParameterAnnotations();
        	if( cacheable.cacheType() == ReadCacheType.Map ){
        		String mapkey = getCacheKey(namespace, assignedKey, anns,pjp.getArgs());
        		String valuekey = getCacheMapValueKey(anns, pjp.getArgs());
        		redisCacheService.removeMap(mapkey,valuekey);
    		    return pjp.proceed();
			} else {
				String key = getCacheKey(namespace, assignedKey, anns,pjp.getArgs());
				if(cacheable.cacheType() == ReadCacheType.String ){
					redisCacheService.remove(key);
					return pjp.proceed();
				}
        	}
        }else{  //方法 缓存没开启
        	getLogger().info("Method cache disabled . Name {}", msig.getName());
            return pjp.proceed();
        }
        return null;
    }
    
}
