package com.biz.eisp.base.core.redis.cache;

import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;

/**
 * Created by 肖胜 on 2017/12/23.
 */
public interface IRedisDictCacheService {

    /**
     * 根据数据字典Code获取值
     * @param typeCode
     * @param dataCode
     * @return
     */
    public  String getDictDataValueByCode(String typeCode,String dataCode);

    /**
     * 根据数据字典值获取code
     * @param typeCode
     * @param dataValue
     * @return
     */
    public String getDictCodeByValue(String typeCode,String dataValue);

    /**
     * 根据数据字典codes（以，号分割）获取值
     * @param typeCode 类型code
     * @param dataValues 值
     * @return 值以，号分割
     */
    public String getDictDatasByCodes(String typeCode,String dataValues);

    /**
     * 获取字典对象
     * @param typeCode 类型code
     * @param dataCode code
     * @return
     */
    public TmDictDataVo getDicData(String typeCode, String dataCode);

    /**
     * 获取字典名
     * @param typeCode 类型code
     * @param dataCode code
     * @return
     */
    public String getDicDataValue(String typeCode,String dataCode);

    /**
     * 刷新缓存
     * @param dictTypeCode
     * @return
     */
    public void syncDictCache(String dictTypeCode);
}
