package com.biz.eisp.base.core.redis.util;

import com.biz.eisp.base.core.redis.cache.IRedisCacheService;

/**
 * 业务锁工具
 * @author xuduan
 *
 */
public class LockUtils {
	private static final int defaultExpire = 120;//默认120s
	private IRedisCacheService redisService;
	public LockUtils(IRedisCacheService redisCacheService){
		this.redisService=redisCacheService;
	}
	public  boolean lock(String key)  {
		return lock2(key, defaultExpire);
	}

	/**
	 * 加锁
	 * @param key redis key
	 * @param expire 过期时间，单位秒
	 * @return true:加锁成功，false，加锁失败
	 */
	public  boolean lock2(String key, int expire){
		try {
			long value = System.currentTimeMillis() + expire*1000;

			long status = redisService.setnx(key, String.valueOf(value));

			if(status == 1) {//表示 获取锁成功   为0 表示  已经占用锁了
                return true;
            }
			long oldExpireTime = redisService.get(key,Long.class);
			System.out.print(oldExpireTime+"\n");
			System.out.print(System.currentTimeMillis()+"\n");
			System.out.print(System.currentTimeMillis() -oldExpireTime);
			if(oldExpireTime < System.currentTimeMillis()) {
                //超时
                long newExpireTime = System.currentTimeMillis() + expire*1000;
                //将给定 key 的值设为 value ，并返回 key 的旧值 (old value)，
                // 当 key 存在但不是字符串类型时，返回一个错误，当key不存在时，返回nil
                String curr = redisService.getSet(key, String.valueOf(newExpireTime));
                long currentExpireTime=curr!=null?Long.valueOf(curr.replace("\"","")):0;
                if(currentExpireTime == oldExpireTime) {
                    return true;
                }
            }
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;
	}

	/**
	 * 解锁 直接删除键值
	 * @param key
	 * @throws Exception
	 */
	public  void unLock(String key){
		try {
			redisService.remove(key);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
