package com.biz.eisp.base.core.redis.util;

import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.cache.IRedisDictCacheService;
import com.biz.eisp.base.utils.ApplicationContextUtils;

/**
 * Redis 工具类
 * Created by liukai on 2018/1/10.
 */
public class RedisUtils {

    public static IRedisDictCacheService getIRedisDictCacheService() {
        String[] beanTypes = ApplicationContextUtils.getContext().getBeanNamesForType(IRedisDictCacheService.class);
        IRedisDictCacheService redisDictCacheService = null;
        if (beanTypes.length > 0) {
            redisDictCacheService = ApplicationContextUtils.getContext().getBean(IRedisDictCacheService.class);
        }
        return redisDictCacheService;
    }

    public static IRedisCacheService getIRedisCacheService() {
        String[] beanTypes = ApplicationContextUtils.getContext().getBeanNamesForType(IRedisCacheService.class);
        IRedisCacheService redisCacheService = null;
        if (beanTypes.length > 0) {
            redisCacheService = ApplicationContextUtils.getContext().getBean(IRedisCacheService.class);
        }
        return redisCacheService;
    }
}
