package com.biz.eisp.base.core.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.service.TbAttachmentExtendsService;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.*;
import com.biz.eisp.base.core.dao.BaseDao;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.*;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.entity.TmLogEntity;
import com.biz.eisp.log.vo.OperationType;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;

/**
 * <p>
 * 基础Service 接口实现
 * <p>
 * @author liukai
 */
@SuppressWarnings("deprecation")
@Service("baseService")
@Transactional
public class BaseServiceImpl implements BaseService {

	/**
	 * 注入 BaseDao 接口
	 */
	@Autowired
	private BaseDao baseDao;

	@Autowired
	private SysConfigUtils sysConfigUtils;
	
	@Autowired
	@Qualifier("jdbcTemplate")
	private JdbcTemplate jdbcTemplate;

	public Session getSession() {
		return baseDao.getSession();
	}
	
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}
	
	@Override
	public <T> Serializable save(T entity) {
		return baseDao.save(entity);
	}

	@Override
	public <T> void saveOrUpdate(T entity) {
		baseDao.saveOrUpdate(entity);
	}

	@Override
	public <T> void batchSave(List<T> entities) {
		baseDao.batchSave(entities);
	}

	@Override
	public <T> void delete(T entity) {
		baseDao.delete(entity);
	}

	@Override
	public <T> void deleteEntityById(Class<T> clazz, Serializable id) {
		baseDao.deleteEntityById(clazz, id);
	}

	@Override
	public <T> void deleteAllEntity(Collection<T> entities) {
		baseDao.deleteAllEntity(entities);
	}

	@Override
	public <T> void updateEntity(T entity) {
		baseDao.updateEntity(entity);
	}

	@Override
	public <T> T get(Class<T> clazz, Serializable id) {
		return baseDao.get(clazz, id);
	}

	@Override
	public <T> List<T> findByProperty(Class<T> clazz, String propertyName, Object value) {
		return baseDao.findByProperty(clazz, propertyName, value);
	}

	@Override
	public <T> List<T> findByPropertyisOrder(Class<T> clazz, 
			String propertyName, Object value, boolean isAsc,String isAscForpropertyName) {
		return baseDao.findByPropertyisOrder(clazz, propertyName, value, isAsc,isAscForpropertyName);
	}

	@Override
	public <T> T findUniqueByProperty(Class<T> clazz, String propertyName, Object value) {
		return baseDao.findUniqueByProperty(clazz, propertyName, value);
	}

	@Override
	public <T> List<T> loadAll(Class<T> clazz) {
		return baseDao.loadAll(clazz);
	}

	@Override
	public Integer executeSql(String sql, Object... params) {
		return baseDao.executeSql(sql, params);
	}

	@Override
	public Long getCountForJdbcParam(String sql, Object... params) {
		return baseDao.getCountForJdbcParam(sql, params);
	}

	@Override
	public List<Map<String, Object>> findForMapList(String sql, Object... objs) {
		return baseDao.findForMapList(sql, objs);
	}

	@Override
	public Map<String, Object> findForMap(String sql, Object... objs) {
		return baseDao.findForMap(sql, objs);
	}

	@Override
	public <T> List<T> findByHql(String hql, Page page, Object... params) {
		return baseDao.findByHql(hql, page, params);
	}
	
	@Override
	public <T> List<T> findByHql(String hql, Object... params) {
		return baseDao.findByHql(hql, params);
	}

	@Override
	public <T> T getUniqueByHql(Class<T> clazz, String hql, Object... params) {
		return baseDao.getUniqueByHql(clazz, hql, params);
	}
	
	@Override
	public <T> List<T> findBySql(Class<T> clazz, String sql, Page page, Object... params) {
		return baseDao.findBySql(clazz, sql, page, params);
	}

	@Override
	public <T> List<T> findBySql(Class<T> clazz, String sql, Object... params) {
		return baseDao.findBySql(clazz, sql, params);
	}

	@Override
	public <T> T getUniqueBySql(Class<T> clazz, String sql, Object... params) {
		return baseDao.getUniqueBySql(clazz, sql, params);
	}

	@Override
	public <T> List<T> findByCriteria(Class<T> clazz, boolean isAsc,String isAscForpropertyName,Criterion... criterions) {
		return baseDao.findByCriteria(clazz, isAsc,isAscForpropertyName, criterions);
	}

	@Override
	public <T> List<T> findByCriteria(Class<T> clazz, Criterion... criterions) {
		return baseDao.findByCriteria(clazz, criterions);
	}
	
	@Override
	public void updateBySql(String sql, Object... param) {
		baseDao.updateBySql(sql, param);
	}
	
    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, Page page, List<Criterion> criterions) {
        return baseDao.findByCriteria(clazz,page, criterions);
    }

	@Override
	public List<TreeGrid> treegrid(List all, TreeGridModel treeGridModel) {
		List<TreeGrid> treegrid = new ArrayList<TreeGrid>();
		for (Object obj : all) {
			ReflectHelper reflectHelper = new ReflectHelper(obj);
			TreeGrid tg = new TreeGrid();
			String id = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getIdField()));
			String src = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getSrc()));
			String text = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getTextField()));
			
			if (StringUtil.isNotEmpty(treeGridModel.getCode())) {
				String code = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getCode()));
				tg.setCode(code);
			}
			if (StringUtil.isNotEmpty(treeGridModel.getOrder())) {
				String order = OConvertUtils.getString(reflectHelper.getMethodValue(treeGridModel.getOrder()));
				tg.setOrder(order);
			}
			tg.setId(id);
			tg.setSrc(src);
			tg.setText(text);
	
			if (treeGridModel.getParentId() != null) {
				Object pid = TagUtil.fieldNametoValues(treeGridModel.getParentId(), obj);
				if (pid != null) {
					tg.setParentId(pid.toString());
				} else {
					tg.setParentId("");
				}
			}
			
			if (treeGridModel.getIcon() != null) {
				Object icon = TagUtil.fieldNametoValues(treeGridModel.getIcon(), obj);
				if (icon != null) {
					tg.setIcon(icon.toString());
				} 
			}
			
			
			if (treeGridModel.getParentText() != null) {
				Object ptext = TagUtil.fieldNametoValues(treeGridModel.getTextField(), obj);
				if (ptext != null) {
					tg.setParentText(ptext.toString());
				} else {
					tg.setParentText("");
				}

			}
			List childList = (List) reflectHelper.getMethodValue(treeGridModel.getChildList());
			if (childList != null && childList.size() > 0) {
				tg.setState("closed");
			}
			
			if (treeGridModel.getFieldMap() != null) {
                tg.setFieldMap(new HashMap<String, Object>());
                for (Map.Entry<String, Object> entry : treeGridModel.getFieldMap().entrySet()) {
                    Object fieldValue = reflectHelper.getMethodValue(entry.getValue().toString());
                    tg.getFieldMap().put(entry.getKey(), fieldValue);
                }
            }
			// 字段级权限（表单，列表）
			treegrid.add(tg);
		}
		return treegrid;
	}

	public List<ComboTree> comboTree(List all, 
			ComboTreeModel comboTreeModel, List in, boolean recursive) {
		List<ComboTree> trees = new ArrayList<ComboTree>();
		for (Object obj : all) {
			trees.add(comboTree(obj, comboTreeModel, in, recursive));
		}
		all.clear();
		return trees;
	}

	/**
	 * 构建ComboTree
	 * @param obj  处理对象集合
	 * @param comboTreeModel  ComboTree模型
	 * @param in 选中项
	 * @param recursive 是否递归子节点
	 * @return
	 */
	public ComboTree comboTree(Object obj, 
			ComboTreeModel comboTreeModel, List in, boolean recursive) {
		ComboTree tree = new ComboTree();
		Map<String, Object> attributes = new HashMap<String, Object>();
		ReflectHelper reflectHelper = new ReflectHelper(obj);
		String id = OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
		tree.setId(id);
		tree.setText(OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getTextField())));
		if (comboTreeModel.getSrcField() != null) {
			attributes.put("href", OConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getSrcField())));
			tree.setAttributes(attributes);
		}
		if (in == null) {
		} else {
			if (in.size() > 0) {
				for (Object inobj : in) {
					ReflectHelper reflectHelper2 = new ReflectHelper(inobj);
					String inId = OConvertUtils.getString(reflectHelper2.getMethodValue(comboTreeModel.getIdField()));

					if (inId.equals(id)) {
						tree.setChecked(true);
					}
				}
			}
		}

		List curChildList = (List) reflectHelper.getMethodValue(comboTreeModel.getChildField());
		if (curChildList != null && curChildList.size() > 0) {
			tree.setState("closed");
			tree.setChecked(false);
			if (recursive) { // 递归查询子节点
				List<ComboTree> children = new ArrayList<ComboTree>();
				List nextChildList = new ArrayList(curChildList);
				for (Object childObj : nextChildList) {
					ComboTree t = comboTree(childObj, comboTreeModel, in, recursive);
					children.add(t);
				}
				tree.setChildren(children);
			}
			curChildList.clear();
		}
		
		return tree;
	}

	@Override
	public List<ComboBox> comboBoxByDict(String dictTypeCode) {
		String sql="select dict_code value,dict_value text  from tm_dict_data where dict_type_code=?";
		return  this.findBySql(ComboBox.class,sql,dictTypeCode);
	}
	
	@Override
	public void addLog(OperationType operationType,String businessDesc,String businessId,String logContent){
		TmLogEntity tmLogEntity = new TmLogEntity();
		tmLogEntity.setContent(logContent);
		tmLogEntity.setOperationType(operationType.toString());
		tmLogEntity.setBusinessId(businessId);
		tmLogEntity.setBusinessDesc(businessDesc);
		tmLogEntity.setPositionName(ResourceConfigUtils.getCurrPosition().getPositionName());
		this.save( tmLogEntity);
	}

	 /**
     * 
     * @param list
     *            传入节点集合
     * @return
     */
    @Override
    public List<ComboTree> findComboTreeByAll(List<?> list, ComboTreeModel comboTreeModel, List<?> in,
                    ComboTreeModel intreeModel) {
        List<ComboTree> treeJsons = new ArrayList<ComboTree>();
        for (int i = 0; i < list.size(); i++) {
            ComboTree tsJson2 = new ComboTree();
            ReflectHelper reflectHelper = new ReflectHelper(list.get(i));
            String ids = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
            String pids = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getChildField()));
            String texts = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getTextField()));
            tsJson2.setId(ids);
            tsJson2.setPid(pids);
            tsJson2.setText(texts);
            treeJsons.add(tsJson2);
        }
        sortObjects(treeJsons);// 对数据排序
        return formatTree(treeJsons, in, intreeModel);
    }

    /**
     * 对数据集合排序
     * 
     * @param treeJsons
     */
    protected void sortObjects(List<ComboTree> treeJsons) {
        Collections.sort(treeJsons, new Comparator<ComboTree>() {
        	@Override
            public int compare(ComboTree a,
                            ComboTree b) {
                String one = a.getId();
                String two = b.getId();
                return one.compareTo(two);
            }
        });
    }

    /******** setter and getter **********/
    public List<ComboTree> formatTree(List<ComboTree> list, List<?> in, ComboTreeModel intreeModel) {
        ComboTree root = new ComboTree();
        ComboTree node = new ComboTree();
        List<ComboTree> treelist = new ArrayList<ComboTree>();// 拼凑好的json格式的数据
        List<ComboTree> parentnodes = new ArrayList<ComboTree>();// parentnodes存放所有的父节点
        if (list != null && list.size() > 0) {
            root = list.get(0);
            // 循环遍历oracle树查询的所有节点
            for (int i = 1; i < list.size(); i++) {
                node = list.get(i);
                if (node.getPid().equals(root.getId())) {
                    // 为tree root 增加子节点
                    parentnodes.add(node);
                    root.getChildren().add(node);
                } else {// 获取root子节点的孩子节点
                    getChildrenNodes(parentnodes, node, in, intreeModel);
                    parentnodes.add(node);
                }

            }
        }
        treelist.add(root);
        return treelist;

    }

    private void getChildrenNodes(List<ComboTree> parentnodes, ComboTree node, List<?> in, ComboTreeModel intreeModel) {
        if (in != null && in.size() > 0) {
            for (Object inobj : in) {
                ReflectHelper reflectHelperIn = new ReflectHelper(inobj);
                String inId = oConvertUtils.getString(reflectHelperIn.getMethodValue(intreeModel.getChildField()));
                if (StringUtil.isNotBlank(inId) && inId.equals(node.getId())) {
                    node.setChecked(true);
                }
            }
        }
        // 循环遍历所有父节点和node进行匹配，确定父子关系
        for (int i = parentnodes.size() - 1; i >= 0; i--) {
            ComboTree pnode = parentnodes.get(i);
            // 如果是父子关系，为父节点增加子节点，退出for循环
            if (pnode.getId().equals(node.getPid())) {
                pnode.setState("closed");// 关闭二级树
                pnode.getChildren().add(node);
                return;
            } else {
                // 如果不是父子关系，删除父节点栈里当前的节点，
                // 继续此次循环，直到确定父子关系或不存在退出for循环
                // parentnodes.remove(i) ;

            }
        }
    }
    
    public Object uploadFile(UploadFile uploadFile) {
    	return this.uploadFile(uploadFile, null, null);
    }
    
    public Object uploadFile(UploadFile uploadFile, String extendServiceName, String businessKey) {
		Object object = uploadFile.getObject();
		if(uploadFile.getFileKey() != null) {
			this.updateEntity(object);
		} else {
			try {
				uploadFile.getMultipartRequest().setCharacterEncoding("UTF-8");
				MultipartHttpServletRequest multipartRequest = uploadFile.getMultipartRequest();
				ReflectHelper reflectHelper = new ReflectHelper(uploadFile.getObject());
				String uploadbasepath = uploadFile.getBasePath();// 文件上传根目录
				if (uploadbasepath == null) {
					//uploadbasepath = ResourceUtil.getSysConfigProperty("uploadpath");
					uploadbasepath = sysConfigUtils.getUploadpath();
				}
				Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
				// 文件数据库保存路径
				String path = uploadbasepath + "/";// 文件保存在硬盘的相对路径
				// 文件的硬盘真实路径
				//String realPath=ResourceUtil.getSysConfigProperty("basePath");
				String realPath= sysConfigUtils.getBasePath();
				File templateFile=new File(realPath);
				if(!templateFile.exists()&&!templateFile.isDirectory()){
					realPath= uploadFile.getMultipartRequest().getSession()
							.getServletContext().getRealPath("/") + "/"+path;
				}else{
					realPath=realPath+ "/" + path;
				}
				
				File file = new File(realPath);
				if (!file.exists()) {
					file.mkdirs();// 创建根目录
				}
				if (uploadFile.getCusPath() != null) {
					realPath += uploadFile.getCusPath() + "/";
					path += uploadFile.getCusPath() + "/";
					file = new File(realPath);
					if (!file.exists()) {
						file.mkdirs();// 创建文件自定义子目录
					}
				}
				else {
					realPath += DateUtils.getDataString(DateUtils.yyyyMMdd) + "/";
					path += DateUtils.getDataString(DateUtils.yyyyMMdd) + "/";
					file = new File(realPath);
					if (!file.exists()) {
						file.mkdir();// 创建文件时间子目录
					}
				}
				String entityName = uploadFile.getObject().getClass().getSimpleName();
				// 设置文件上传路径
				if (entityName.equals("TbTemplate")) {
					realPath = uploadFile.getMultipartRequest()
							.getSession().getServletContext().getRealPath("/")
//							+ ResourceUtil.getSysConfigProperty("templatepath") + "/";
							+ sysConfigUtils.getTemplatepath() + "/";
					//path = ResourceUtil.getSysConfigProperty("templatepath") + "/";
					path = sysConfigUtils.getTemplatepath() + "/";
				}
				else if (entityName.equals("TbIcon")) {
					realPath = uploadFile.getMultipartRequest()
							.getSession().getServletContext().getRealPath("/") 
							+ uploadFile.getCusPath() + "/";
					path = uploadFile.getCusPath() + "/";
				}
				
				String fileName = "";
				String swfName = "";
				for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
					MultipartFile mf = entity.getValue();// 获取上传文件对象
					fileName = mf.getOriginalFilename();// 获取文件名
					swfName = PinyinUtil.getPinYinHeadChar(OConvertUtils
							.replaceBlank(FileUtils.getFilePrefix(fileName)));// 取文件名首字母作为SWF文件名
					String extend = FileUtils.getExtend(fileName);// 获取文件扩展名
					String myfilename="";
					String noextfilename="";//不带扩展名
					
					if(uploadFile.isRename()){
					   noextfilename=DateUtils.getDataString(DateUtils.yyyymmddhhmmss)+StringUtil.random(8);//自定义文件名称
					   myfilename=noextfilename+"."+extend;//自定义文件名称
					}
					else {
					  myfilename=fileName;
					}
					
					String savePath = realPath + myfilename;// 文件保存全路径
					String fileprefixName = FileUtils.getFilePrefix(fileName);
					if (uploadFile.getTitleField() != null) {
						reflectHelper.setMethodValue(uploadFile.getTitleField(), fileprefixName);// 动态调用set方法给文件对象标题赋值
					}
					if (uploadFile.getExtend() != null) {
						// 动态调用 set方法给文件对象内容赋值
						reflectHelper.setMethodValue(uploadFile.getExtend(), extend);
					}
					if (uploadFile.getByteField() != null) {
						// 二进制文件保存在数据库中
	//					reflectHelper.setMethodValue(uploadFile.getByteField(), StreamUtils.InputStreamTOByte(mf.getInputStream()));
					}
					File savefile = new File(savePath);
					if (uploadFile.getRealPath() != null) {
						// 设置文件数据库的物理路径
						reflectHelper.setMethodValue(uploadFile.getRealPath(), path + myfilename);
					}
	                //文件保存在硬盘的名称（没有扩展名） 方便取缩略图
	                if (uploadFile.getFileName() != null) {
	                    if (uploadFile.isRename()) {
	                        reflectHelper.setMethodValue(uploadFile.getFileName(), noextfilename);
	                    } else {
	                        reflectHelper.setMethodValue(uploadFile.getFileName(), fileName);
	                    }
	                }
	
					saveOrUpdate(object);
					
					if(StringUtils.hasText(extendServiceName)) {
						TbAttachmentExtendsService tbAttachmentExtendsService = ApplicationContextUtils.getContext().getBean(extendServiceName, TbAttachmentExtendsService.class);
						tbAttachmentExtendsService.savePostProcessor(businessKey);
					}
					
					// 文件拷贝到指定硬盘目录
					if("txt".equals(extend)){
						//利用utf-8字符集的固定首行隐藏编码原理
						//TODO neal 文件拷贝到磁盘，封装方法   
						this.copyToDisk(mf,savePath);
					} else {
							FileCopyUtils.copy(mf.getBytes(), savefile);
					}
					if (uploadFile.getSwfpath() != null) {
						// 转SWF
						reflectHelper.setMethodValue(uploadFile.getSwfpath(), path + FileUtils.getFilePrefix(myfilename) + ".swf");
	//						SwfToolsUtil.convert2SWF(savePath);
					}
				}
			} catch (IOException e) {
				e.printStackTrace();
				throw new BusinessException("上传附件失败");
			}
		}
		return object;
	}
    
	/**
	 * 将文件拷贝到指定的硬盘目录
	 * */
	private void copyToDisk(MultipartFile mf , String savePath){

		//利用utf-8字符集的固定首行隐藏编码原理
		//Unicode:FF FE   UTF-8:EF BB   
		try{
			byte[] allbytes = mf.getBytes();
			String head1 = toHexString(allbytes[0]);
			String head2 = toHexString(allbytes[1]);
			if("ef".equals(head1) && "bb".equals(head2)){
				//UTF-8
				String contents = new String(mf.getBytes(),"UTF-8");
				if(StringUtil.isNotBlank(contents)){
					OutputStream out = new FileOutputStream(savePath);
					out.write(contents.getBytes());
					out.close();
				}
			}  else {
				//GBK
				String contents = new String(mf.getBytes(),"GBK");
				OutputStream out = new FileOutputStream(savePath);
				out.write(contents.getBytes());
				out.close();

			}
		  } catch(Exception e){
			  try{
			  String contents = new String(mf.getBytes(),"UTF-8");
				if(StringUtil.isNotBlank(contents)){
					OutputStream out = new FileOutputStream(savePath);
					out.write(contents.getBytes());
					out.close();
				}
			  }
				catch(Exception e2){
					e2.printStackTrace();
				}
		}
	}
	
	private String toHexString(int index){
        String hexString = Integer.toHexString(index);   
        // 1个byte变成16进制的，只需要2位就可以表示了，取后面两位，去掉前面的符号填充   
        hexString = hexString.substring(hexString.length() -2);  
        return hexString;
	}
	
	@Override
    public String generateTreeSubCode(Integer codeLength,String tableName,String parentId) {
        String  newSubCode = "";
        if(!StringUtils.hasText(parentId)) { // 第一级编码
            String sql = "select max(t.sub_code) subCode from "+tableName+" t where t.parent_id is null";
            Map<String, Object> pCodeMap = baseDao.findForMap(sql);
            if(pCodeMap.get("subCode") != null) {
                String subCode = pCodeMap.get("subCode").toString();
                newSubCode = String.format("%0" + codeLength + "d", Integer.valueOf(subCode) + 1);
            } else {
            	newSubCode = String.format("%0" + codeLength + "d", 1);
            }
        } else { // 下级编码
            String sql = "select max(t.sub_code) subCode from "+tableName+" t where t.parent_id = ?";
            Map<String, Object> subCodeMap = baseDao.findForMap(sql, parentId);
            if(subCodeMap.get("subCode") != null) { // 当前基本有编码时
                String currCode = subCodeMap.get("subCode").toString();
                String pSubCode = currCode.substring(0, currCode.length() - codeLength);
                String subCode = currCode.substring(currCode.length() - codeLength, currCode.length());
                newSubCode = pSubCode + String.format("%0" + codeLength + "d", Integer.valueOf(subCode) + 1);
            } else { // 当前级别没有编码时
                String parentCodeSql = "select max(t.sub_code) subCode from "+tableName+" t where t.id = ?";
                Map<String, Object> pCodeMap = baseDao.findForMap(parentCodeSql, parentId);
                String currCode = pCodeMap.get("subCode").toString();
                newSubCode = currCode + String.format("%0" + codeLength + "d", 1);
            }
        }
        return newSubCode;
    }
	
	public void updateIsLeafColumn(String tableName) {
		Map <String, Object> params = new HashMap<String, Object>();
		params.put("tableName", tableName);
		params.put("isLeaf", 1);
		String isLeafSql_1 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateIsLeafColumnSql.ftl", params);
		params.put("isLeaf", 0);
		String isLeafSql_0 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateIsLeafColumnSql.ftl", params);
		baseDao.executeSql(isLeafSql_1);
		baseDao.executeSql(isLeafSql_0);
	}
	
	public void updateAllIsLeafColumn(String tableName) {
		Map <String, Object> params = new HashMap<String, Object>();
		params.put("tableName", tableName);
		params.put("isLeaf", 1);
		String isLeafSql_1 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateAllIsLeafColumnSql.ftl", params);
		params.put("isLeaf", 0);
		String isLeafSql_0 = new FreemarkerParseUtils().parseTemplate("com/biz/eisp/base/core/service/impl/updateAllIsLeafColumnSql.ftl", params);
		baseDao.executeSql(isLeafSql_1);
		baseDao.executeSql(isLeafSql_0);
	}
	
	public HttpServletResponse viewOrDownloadFile(UploadFile uploadFile) {
		uploadFile.getResponse().setContentType("UTF-8");
		uploadFile.getResponse().setCharacterEncoding("UTF-8");
		InputStream bis = null;
		BufferedOutputStream bos = null;
		HttpServletResponse response = uploadFile.getResponse();
		HttpServletRequest request = uploadFile.getRequest();
		String ctxPath = "";
//		if(StringUtil.isNotBlank(ResourceUtil.getSysConfigProperty("basePath"))) {
//			ctxPath = ResourceUtil.getSysConfigProperty("basePath") + "/";
//		}
		if(StringUtil.isNotBlank(sysConfigUtils.getBasePath())) {
			ctxPath = sysConfigUtils.getBasePath() + "/";
		}

		String downLoadPath = "";
		long fileLength = 0;
		if (uploadFile.getRealPath() != null&&uploadFile.getContent() == null) {
			downLoadPath = ctxPath + uploadFile.getRealPath();
			fileLength = new File(downLoadPath).length();
			try {
				bis = new BufferedInputStream(new FileInputStream(downLoadPath));
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			}
		} else {
			if (uploadFile.getContent() != null)
				bis = new ByteArrayInputStream(uploadFile.getContent());
			fileLength = uploadFile.getContent().length;
		}
		try {
			if (!uploadFile.isView() && uploadFile.getExtend() != null) {
				//TODO 文件的类型设置
				if (uploadFile.getExtend().equals("text")) {
					response.setContentType("text/plain;");
				} else if (uploadFile.getExtend().equals("doc")) {
					response.setContentType("application/msword;");
				} else if (uploadFile.getExtend().equals("xls")) {
					response.setContentType("application/ms-excel;");
				} else if (uploadFile.getExtend().equals("pdf")) {
					response.setContentType("application/pdf;");
				} else if (uploadFile.getExtend().equals("jpg") || uploadFile.getExtend().equals("jpeg")) {
					response.setContentType("image/jpeg;");
				} else {
					response.setContentType("application/x-msdownload;");
				}
				response.setHeader("Content-disposition", 
								"attachment; filename=" + new String((uploadFile.getTitleField()
								+ "." + uploadFile.getExtend()).getBytes("GBK"), "ISO8859-1"));
				response.setHeader("Content-Length", String.valueOf(fileLength));
			}
			bos = new BufferedOutputStream(response.getOutputStream());
			byte[] buff = new byte[2048];
			int bytesRead;
			while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
				bos.write(buff, 0, bytesRead);
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (bis != null) {
					bis.close();
				}
				if (bos != null) {
					bos.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return response;
	}

	@Override
	public void addLogAndRemoveInvalidInfo(String relationId, Object relationObj, String updateToBusinessId,String logContent, String operationType) {
		if(StringUtil.isEmpty(logContent)){
			logContent = ((Loggerable) relationObj).updateLogContent(null);
		}
		String businessDesc = ((Loggerable) relationObj).businessDesc();
		// 创建日志实体
		TmLogEntity tmLogEntity = new TmLogEntity();
		tmLogEntity.setContent(logContent);
		tmLogEntity.setOperationType(operationType);
		tmLogEntity.setBusinessId(updateToBusinessId);
		tmLogEntity.setBusinessDesc(businessDesc);
		tmLogEntity.setPositionName(ResourceConfigUtils.getSessionTmUserVo().getPositionName());
		this.save(tmLogEntity);

		//更新对应关系日志 businessId为职位id
		String hql1="from TmLogEntity where businessId=?";
		List<TmLogEntity> logList=this.findByHql(hql1, relationId);
		for(TmLogEntity logEntity:logList){
			logEntity.setBusinessId(updateToBusinessId);
			this.updateEntity(logEntity);
		}
	}

	@Override
	public void addLogAndRemoveInvalidInfo(String relationId, Object relationObj, String updateToBusinessId,String logContent) {
		this.addLogAndRemoveInvalidInfo(relationId, relationObj, updateToBusinessId,logContent, "DELETE");
	}

	@Override
	public int callableStatementByName(String proc, List<String> list) {
		return baseDao.callableStatementByName(proc, list);
	}

}
