package com.biz.eisp.base.importer;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.biz.eisp.base.common.util.JsonUtil;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.service.BaseService;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.hibernate.CacheMode;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.HibernatePersister;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.DataValidator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.dict.util.DictUtil;


public abstract class AbstractHibernateImporter implements Importer {
	public static final Pattern PATTERN = Pattern
			.compile("(?<=\\$\\{)[\\w|\\.]*(?=\\})");
	public static final int MAX_ERROR_NUM = 200;
	public static final int MAX_MESSAGE_NUM = 200;
	protected ImpConfigurator conf;
	protected Map<String, Object> params;
	protected HibernatePersister persister;
	protected Map<String, DataValidator> validator;
	protected DataIterator iterator;
	protected Map<String, Object> objcache = new HashMap();
	protected StringBuilder errors;
	protected int errNum = 0;
	protected int succNum = 0;
	protected int setNullNum = 0;
	protected int skipRowNum = 0;
	protected int skipColNum = 0;
	protected StringBuilder messages;
	protected Date currTime = new Date();
	protected ImpEventHandler event;
	protected boolean isTest;
	private int commited = 0;
	private ImpInfo impInfo;
	private String batchCode;
	private boolean isDistributed;
	private String key;

	private RedisService redisService;

	private BaseService baseService;

	
	protected Map<String, String> deleted = new HashMap();

	public AbstractHibernateImporter(ImpConfigurator conf,
			Map<String, Object> params) {
		Object isd=params.get(ImportEnum.isDistributed.getValue());
		Object kname=params.get(ImportEnum.keyName.getValue());
		this.isDistributed=isd!=null?
				Boolean.valueOf(isd.toString()):false;
		this.key=kname!=null?kname.toString():"";
		this.conf = conf;
		this.params = params;
		List <DataField>cols = conf.getFields();
		this.validator = new HashMap();
		for (DataField f : cols)
			if (StringUtils.isNotBlank(f.getCode()))
				this.validator.put(f.getCode(), ValidatorFactory
						.createValidator(f));
	}
	public void init() {
		this.errors = new StringBuilder();
		this.errNum = 0;
		this.succNum = 0;
		this.setNullNum = 0;
		this.skipRowNum = 0;
		this.skipColNum = 0;
		this.messages = new StringBuilder();

		Object base = ApplicationContextUtils.getContext().getBean("baseService");
		baseService = base != null ? (BaseService) base : null;
		//编码生成
		/* TbNumRuleProvider tbNumRuleProvider=
				(TbNumRuleProvider) ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
		String importCodeInfo=DictUtil.getDictDataValueByCode("natural_key", Globals.Import);
		if(StringUtil.isNotEmpty(importCodeInfo)){
			String importCode=tbNumRuleProvider.getMaxNum(Globals.Import);
			this.batchCode=importCode;
		}*/ //暂时不需要
	}

	protected void setIterator(DataIterator iterator) {
		this.iterator = iterator;
	}

	public DataIterator getIterator() {
		return this.iterator;
	}

	protected void setPersister(HttpSession session) {
		this.persister = new HibernatePersister(session);
	}
	
	protected void setEventHandler() throws InstantiationException,
			IllegalAccessException {
		if (this.conf.getEventHandler() != null) {
			this.event = ((ImpEventHandler) this.conf.getEventHandler()
					.newInstance());
			this.event.init(this.conf, this.persister, this.params,conf.getTableName());
			this.event.setImporter(this);
		}
	}

	public ImpInfo imp(DataIterator iterator, HttpSession session) throws Exception {
		//找到redis服务
		if (isDistributed) {
			Object redis = ApplicationContextUtils.getContext().getBean("redisService");
			redisService = redis != null ? (RedisService) redis : null;
		}
		this.isTest = false;
		init();
		setIterator(iterator);
		if (isDistributed)
		redisService.hset(this.key,ImportEnum.Size.getValue(), iterator.getSize(),1800);
		try {
			setPersister(session);
			PersisterHolder.setHibernatePersister(this.persister); //当前线程持有此对象
			setEventHandler();
			this.persister.beginTransaction();
			if ((this.conf.isDeleteByKey())
					&& (this.conf.getKeyField() == null)) {
				deleteByKey(null);
			}
			if ((this.errNum == 0) && (this.event != null)) {
				this.event.start();
			}
			ImpInfo info =impData(redisService);
			if (this.errNum == 0) {
				this.persister.flush();
				if (this.event != null) {
					try {
						this.event.end();
					} catch(Exception e) {
						if(e instanceof NoCatchImportException) {
							info.setMessages(e.getMessage());
						} else {
							throw e;
						}
					}
				}
			}
			this.persister.commit();
			if (isDistributed)
			redisService.hset(this.key,ImportEnum.ImpInfo.getValue(), JsonUtil.bean2json(info),1800);
			return info;
		} catch (Exception e) {
			this.persister.rollback();
			if (this.event != null) {
				this.event.fatalError(e);
			}
			e.printStackTrace();
			throw e;
		} finally {
			this.persister.close();
			this.persister = null;
			PersisterHolder.clearHibernatePersister(); //清空线程中的对象
			if (null != event){
				event.impEnd();
			}
		}
	}

	public ImpInfo test(DataIterator iterator) throws Exception {
		this.isTest = true;
		//找到redis服务
		RedisService redisService=null;
		if (isDistributed) {
			Object redis = ApplicationContextUtils.getContext().getBean("redisService");
			redisService = redis != null ? (RedisService) redis : null;
		}
		init();
		setIterator(iterator);
		try {
			setPersister(ContextHolderUtils.getSession());
			setEventHandler();
			log.info("test imp start ...");
			if ((this.errNum == 0) && (this.event != null)) {
				this.event.start();
			}
			ImpInfo info = impData(redisService);
			if ((this.errNum == 0) && (this.event != null)) {
				this.event.end();
			}
			log.info("test imp end ...");
			return info;
		} catch (Exception e) {
			throw e;
		} finally {
			this.persister.close();
			this.persister = null;
		}
	}

	@SuppressWarnings("all")
	protected ImpInfo impData(RedisService redisService) throws ValidateException,
			InstantiationException, IllegalAccessException,
			InvocationTargetException, NoSuchMethodException {

		this.persister.getSession().setCacheMode(CacheMode.GET);
		while (this.iterator.hasNext()) {
			Map<String,Object> row = (Map<String,Object>) this.iterator.next();
			try {
				if (this.iterator.getIndex() >= this.conf.getStartRow()) {
					if (this.event != null) {
						this.event.setIndex(this.iterator.getIndex());
						if (isDistributed)
							redisService.hset(key,ImportEnum.Index.getValue(),this.iterator.getIndex()+"",1800);
						this.event.setRowNumber(this.iterator.getRowNumber());
						if ((this.errNum == 0) && (!this.isTest)) {
							this.event.startRow(row);
						}
						this.event.validate(row);
					}
					Object bean = saveRow(row);
					if ((this.errNum == 0) && (!this.isTest)
							&& (this.event != null) ) {
						this.event.endRow(row, bean);
					}
				}
			} catch (Exception e) {
				throw new RuntimeException(
						new StringBuilder().append(e.getMessage()).append(" (")
								.append("行")
								.append(":")
								.append(this.iterator.getRowNumber()).append(
										")").toString(), e);
			}

			if (this.iterator.getIndex() % 15 == 0) {
				if ((this.errNum == 0) && (!this.isTest)) {
					this.persister.flush();
				}
				this.persister.clear();
			}
			if (this.iterator.getIndex() % this.conf.getBatches() == 0) {
				if ((this.errNum == 0) && (!this.isTest)) {
					if (this.event != null) {
						this.event.end();
					}
					this.persister.commit();
					this.commited += this.conf.getBatches();
					this.persister.beginTransaction();
				}
				log.info(new StringBuilder().append(this.iterator.getIndex())
						.append(" submitted ...").toString());
			}
		}

		if (this.errNum > 0) {
			if (this.commited > 0) {
				addError(new StringBuilder().append("<font color='red'>注意: 前 ").append(
						this.commited).append(
						" 数据已经成功导入.</font>").toString());
			}
			throw new ValidateException(this.errors.toString());
		}
		ImpInfo info = new ImpInfo();
		info.setSuccNum(this.succNum);
		info.setNullNum(this.setNullNum);
		info.setSkipRowNum(this.skipRowNum);
		info.setSkipColNum(this.skipColNum);
		info.setMessages(this.messages.toString());
		return info;
	}

	protected Object saveRow(Map<String, Object> row)
			throws InstantiationException, IllegalAccessException,
			InvocationTargetException, NoSuchMethodException, ValidateException {
		Object bean = null;
		
		//自动保存bean 获取
		DataField[] keyField = this.conf.getKeyField();
		if (keyField != null&&this.conf.isAutoSave()) {
			if (this.conf.isDeleteByKey()) {
				if (!this.isTest)
					deleteByKey(row);
			} else {
				bean = getKeyObject(keyField, bean, row);
			}
		}

		boolean ignoreNull = this.conf.isIgnoreNull();
		boolean isSkip = false;
		for (DataField field : this.conf.getFields())
			if (ignoreNull) {
				String value = (String) row.get(field.getName());
				if ((value == null) || (value.length() == 0))
					;
			} else {
				String prop = field.getCode();
				try {
					Object v = getValue(field, bean, row);
					if (field.isAvailable()) {
						if (prop.indexOf(".") != -1) {
							String[] props = prop.split("\\.");
							if (v != null) {
								v = getRefObject(field, bean, props, v, field
										.getFilter());
							}
							prop = props[0];
						}
//						PropertyUtils.setSimpleProperty(bean, prop, v);
					}
				} catch (Exception e) {
					if ((this.errNum == 0) && (this.event != null)) {
						this.event.error(field, row, e);
					}
					if (("skipRow".equals(field.getOnError()))
							|| (field.isAllowSkip())) {
						if (!isSkip) {
							isSkip = true;
							addMessage(e.getMessage(), "skipRow", row, field);
						}
					} else if ("skipCol".equals(field.getOnError())) {
						addMessage(e.getMessage(), "skipCol", row, field);
					} else if ("setNull".equals(field.getOnError())) {
						PropertyUtils.setSimpleProperty(bean, prop, null);
						addMessage(e.getMessage(), "setNull", row, field);
					} else {
						addError(e.getMessage(), row, field);
					}
				}
			}
		if (this.conf.isAutoSave()) {
			this.event.persisterBean(bean, isSkip);
		}else{
			//1.新方法流程 非自动保存
			bean = this.conf.getEntityClass().newInstance();
			if (StringUtil.isNotEmpty(bean)) {
				try {
					MyBeanUtils.copyMap2Bean(bean, row);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return bean;
	}

	protected void save(Object object) {
		if (this.isTest) {
			return;
		}
		this.persister.save(object);
	}

	protected Object getBean(Class clazz, String[] key, Object[] value,
			String[] filter) {
		StringBuilder sb = new StringBuilder("from ").append(
				clazz.getSimpleName()).append(" where 1=1");

		for (String k : key) {
			sb.append(" and ").append(k).append("=?");
		}
		for (String f : filter) {
			if (StringUtils.isNotBlank(f)) {
				sb.append(" and ").append(f);
			}
		}
		return this.persister.findUnique(sb.toString(), value);
	}

	protected Object getKeyObject(DataField[] keyField, Object bean,
			Map<String, Object> row) {
		if (this.isTest)
			return null;
		try {
			String[] c = new String[keyField.length];
			Object[] v = new Object[keyField.length];

			for (int j = 0; j < keyField.length; j++) {
				DataField df=keyField[j];
				if(df!=null){
					c[j] =df .getCode();
					v[j] = getValue(df, bean, row);
				}
			}

			bean = getBean(this.conf.getEntityClass(), c, v, new String[0]);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return bean;
	}

	protected Object getRefObject(DataField keyField, Object bean,
			String[] prop, Object value, String filter)
			throws IllegalAccessException, InvocationTargetException,
			NoSuchMethodException, ValidateException {
		String objKey = new StringBuilder().append(keyField.getCode()).append(
				".").append(value).toString();
		Object obj = this.objcache.get(objKey);
		if (obj == null) {
			Class propClass = PropertyUtils.getPropertyType(bean, prop[0]);
			int i = keyField.getCode().indexOf(".") + 1;
			obj = getBean(propClass, new String[] { keyField.getCode()
					.substring(i) }, new Object[] { value },
					new String[] { filter });

			if (obj != null) {
				this.objcache.put(objKey, obj);
			}
		}
		if (obj == null) {
			throw new ValidateException(new StringBuilder().append(
					keyField.getTitle()).append("关联的对象不存在！").toString());
		}

		return obj;
	}

	protected Object getValue(DataField field, Object bean,
			Map<String, Object> row) throws ValidateException {
		
		if(StringUtil.isNotEmpty(field.getFormat())){
			return row.get(field.getCode());
		}
		
		String value = (String) row.get(field.getCode());
		if (StringUtils.isNotBlank(field.getValue())) {
			value = eval(new Object[] { row, bean, this.params }, field
					.getValue());
		}

		DataValidator dv = (DataValidator) this.validator.get(field.getCode());
		Object v = null;
		if (dv != null) {
			v = dv.validate(value);
		}
		if ("".equals(v)) {
			v = null;
		}
		if(v instanceof Integer){
			v = Integer.parseInt(String.valueOf(v));
		}
		if(v instanceof Double){
			v = BigDecimal.valueOf((Double)v);
		}
		
		if(StringUtils.isNotBlank(field.getIdBySql())) {
			v = null;
			if (org.apache.commons.lang3.StringUtils.isNotBlank(value)){
				Map<String, Object> objectMap=baseService.findForMap(field.getIdBySql(), new Object[]{value});
				if (objectMap !=null){
					v = objectMap.get("id");
				}
				if(v==null&&StringUtil.isNotEmpty(value)){
					this.event.addError("第"+this.iterator.getRowNumber()+"行:"+field.getTitle()+"输入有误，未找到数据");
				}
				row.put(field.getCode(), (String)v);
			}
		}
		
		return v;
	}

	protected void deleteByKey(Map<String, Object> row)
			throws ValidateException {
		String className = this.conf.getEntityClass().getSimpleName();
		String idName = this.persister.getIdName(this.conf.getEntityClass());

		DataField[] keyField = this.conf.getKeyField();
		String key = "_";
		Object[] value = new Object[keyField.length];
		StringBuilder sb = new StringBuilder("delete from ").append(className);
		sb.append(" where ").append(idName).append(" in (");
		sb.append(" select ").append(idName);
		sb.append(" from ").append(className).append(" where 1=1");
		for (int j = 0; j < keyField.length; j++) {
			value[j] = getValue(keyField[j], null, row);
			key = new StringBuilder().append(key).append(value[j]).append("_")
					.toString();
			sb.append(" and ").append(keyField[j].getCode()).append("=?");
		}
		sb.append(")");
		if (!this.deleted.containsKey(key)) {
			this.persister.createQuery(sb.toString(), value).executeUpdate();
			this.deleted.put(key, "");
		}
	}

	protected String eval(Object[] objects, String exp) {
		if (StringUtils.isBlank(exp)) {
			return "";
		}

		Matcher matcher = PATTERN.matcher(exp);
		while (matcher.find()) {
			String name = matcher.group();

			Object result = null;
			for (Object obj : objects) {
				try {
					result = PropertyUtils.getProperty(obj, name);
				} catch (Exception e) {
				}
				if (result != null) {
					break;
				}
			}
			exp = StringUtils.replace(exp, new StringBuilder().append("${")
					.append(name).append("}").toString(), result == null ? ""
					: result.toString());
		}

		return exp == null ? "" : exp;
	}

	protected void addMessage(String message, String onError) {
		this.messages.append(message).append("<br/>");
		if ("skipRow".equals(onError))
			this.skipRowNum += 1;
		else if ("skipCol".equals(onError))
			this.skipColNum += 1;
		else if ("setNull".equals(onError))
			this.setNullNum += 1;
	}

	protected void addMessage(String message, String onError,
			Map<String, Object> row, DataField field) {
		message = new StringBuilder().append(message).append(" (").append("行")
				.append(":").append(
						this.iterator.getRowNumber()).append(", ").append(
								"列").append(":").append(
						field.getName()).append(", ").append(
								"值").append(":").append(
						(String) row.get(field.getName())).append(")")
				.toString();

		addMessage(message, onError);
	}

	protected void addError(String error) throws ValidateException {
		this.errors.append(error).append("<br/>");
		this.errNum += 1;
		if (this.errNum > 200)
			throw new ValidateException(this.errors.toString());
	}

	protected void addError(String error, Map<String, Object> row,
			DataField field) throws ValidateException {
		error = new StringBuilder().append(error).append(" (").append("行")
				.append(":").append(
						this.iterator.getRowNumber()).append(", ").append("列").append(":").append(
						field.getName()).append(", ").append(
						"值").append(":").append(
						(String) row.get(field.getName())).append(")")
				.toString();
		addError(error);
	}

	/**
	 * 生成模板
	 */
	public void template(HttpServletResponse response) throws IOException {
		HSSFWorkbook wb = new HSSFWorkbook();
		HSSFSheet sheet = wb.createSheet();
		HSSFRow row = sheet.createRow(this.conf.getStartRow() - 2);

		HSSFFont font = wb.createFont();

		int[] rgb = { 127, 127, 127 };
		HSSFPalette palette = wb.getCustomPalette();
		palette.setColorAtIndex((short) 8, (byte) rgb[0], (byte) rgb[1],
				(byte) rgb[2]);

		setFont(font, (short) 8);

		HSSFCellStyle headerStyle = wb.createCellStyle();
		setCellStyle(font, headerStyle);

		HSSFFont reqFont = wb.createFont();
		setFont(reqFont, (short) 10);

		HSSFCellStyle reqHeaderStyle = wb.createCellStyle();
		setCellStyle(reqFont, reqHeaderStyle);

		HSSFFont blueFont = wb.createFont();
		setFont(blueFont, (short) 12);

		HSSFCellStyle blueHeaderStyle = wb.createCellStyle();
		setCellStyle(blueFont, blueHeaderStyle);

		List fields = this.conf.getFields();
		for (short i = 0; i < fields.size(); i = (short) (i + 1)) {
			DataField field = (DataField) fields.get(i);
			if (StringUtils.isNotBlank(field.getName())) {
				HSSFCell cell = row.createCell(Integer
						.parseInt(field.getName()) - 1);

				if (field.isRequired())
					cell.setCellStyle(reqHeaderStyle);
				else if (StringUtils.isNotBlank(field.getCode()))
					cell.setCellStyle(blueHeaderStyle);
				else {
					cell.setCellStyle(headerStyle);
				}
				
				if(field.getList()!=null&&field.getList().length>0){
					DataValidationHelper helper = sheet.getDataValidationHelper();
					// 四个参数分别是：起始行、终止行、起始列、终止列
					CellRangeAddressList regions = new CellRangeAddressList(1,1,i,i);  
					//生成下拉框内容  
					DVConstraint constraint = DVConstraint.createExplicitListConstraint(field.getList());  
					//绑定下拉框和作用区域  
					DataValidation data_validation = helper.createValidation(constraint, regions);
					//对sheet页生效  
					sheet.addValidationData(data_validation);  
				}
				

				String columnName = field.getTitle();
				cell.setCellValue(columnName);
				sheet.setColumnWidth(Short.parseShort(field.getName()) - 1,
						columnName.getBytes().length * 280);
			}
		}

		String fileName = this.conf.getTemplateName();

		if (StringUtils.isBlank(fileName)) {
			fileName = "template.xls";
		}
		response.setContentType("application/octet-stream");
		response.setHeader("Content-Disposition", new StringBuilder().append(
				"attachment;filename=").append(
				new String(fileName.getBytes("GBK"), "ISO-8859-1")).append(
				".xls").toString());

		response.setHeader("Cache-Control",
				"must-revalidate, post-check=0, pre-check=0");

		response.setHeader("Pragma", "public");
		response.setDateHeader("Expires", System.currentTimeMillis() + 1000L);
		wb.write(response.getOutputStream());
	}

	private void setFont(HSSFFont reqFont, short color) {
		reqFont.setBoldweight((short) 400);
		reqFont.setColor(color);
		reqFont.setFontName("Arial");
		reqFont.setFontHeightInPoints((short) 8);
	}

	private void setCellStyle(HSSFFont reqFont, HSSFCellStyle reqHeaderStyle) {
		reqHeaderStyle.setFont(reqFont);
		reqHeaderStyle.setFillForegroundColor((short) 22);
		reqHeaderStyle.setFillPattern((short) 1);
		reqHeaderStyle.setBorderBottom((short) 1);
		reqHeaderStyle.setBottomBorderColor((short) 8);
		reqHeaderStyle.setBorderLeft((short) 1);
		reqHeaderStyle.setLeftBorderColor((short) 8);
		reqHeaderStyle.setBorderRight((short) 1);
		reqHeaderStyle.setRightBorderColor((short) 8);
		reqHeaderStyle.setBorderTop((short) 1);
		reqHeaderStyle.setTopBorderColor((short) 8);
		reqHeaderStyle.setAlignment((short) 2);
		reqHeaderStyle.setVerticalAlignment((short) 1);
	}

	public ImpInfo getImpInfo() {
		return impInfo;
	}

	public void setImpInfo(ImpInfo impInfo) {
		this.impInfo = impInfo;
	}

	public String getBatchCode() {
		return batchCode;
	}

}