package com.biz.eisp.base.importer;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.HibernatePersister;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;


public abstract class ImpEventHandler<T> {
	private AbstractHibernateImporter importer;
	private ImpConfigurator conf;
	private HibernatePersister persister;
	private Map<String, Object> params;
	private int index;
	private int rowNumber;
	protected String tableName=null;
	
	public final void init(ImpConfigurator conf, HibernatePersister persister,
			Map<String, Object> params,String tableName) {
		this.conf = conf;
		this.persister = persister;
		this.params = params;
		this.tableName=tableName;
	}

	/**
	 * 钩子方法：默认持久化
	 * @param bean
	 * @param isSkip
	 */
	protected void persisterBean(Object bean, boolean isSkip) {
		if ((importer.errNum == 0) && (!isSkip)&&bean!=null) {
			importer.succNum += 1;
			importer.save(bean);
		}
	}
	
	public final void setImporter(AbstractHibernateImporter imp) {
		this.importer = imp;
	}

	public final void addMessage(String message, String onError) {
		this.importer.addMessage(message, onError);
	}

	public final void addMessage(String message, String onError,
			Map<String, Object> row, DataField field) {
		this.importer.addMessage(message, onError, row, field);
	}

	public final void addError(String error) throws ValidateException {
		this.importer.addError(error);
	}

	public final void addError(String error, Map<String, Object> row,
			DataField field) throws ValidateException {
		this.importer.addError(error, row, field);
	}

	public void start() {
	}

	public void startRow(Map<String, Object> row) throws ValidateException {
	}

	public void validate(Map<String, Object> row) throws ValidateException {
		if(StringUtil.isNotEmpty(this.tableName)){
			validateDynamicImp(row);
		}
	}
	
	/**
	 * 动态导入自动验证
	 * @param row
	 * @throws ValidateException
	 */
	public void validateDynamicImp(Map<String, Object> row) throws ValidateException{
		//导入字段map
		 List<TmMdmTableConfigEntity> list=DynamicConfigUtil.
				allTableConfigImpColumn.get(tableName.toUpperCase());
		Map<String,Object> requiredFieldMap=new HashMap<String,Object>();
		for(TmMdmTableConfigEntity tableConfig:list){
		 Object fieldValue=row.get(tableConfig.getField());
		 if(fieldValue instanceof Date){
			 continue;
		 }
			String errorMsg=ValidatorFactory.
					validateDynamicImplData(tableConfig, fieldValue);
			if(StringUtil.isNotEmpty(errorMsg)){
				addError("第"+getRowNumber()+"行:"+errorMsg);
			}
			if(tableConfig.getRequired()!=null&&tableConfig.getRequired()==1){
				requiredFieldMap.put(tableConfig.getColumnName(), fieldValue);
			}
		}
		//验证必填字段重复
		if(!requiredFieldMap.isEmpty()){
			//必填字段重复验证 用户姓名可重复
			String sql="select id from "+tableName +" where 1=1";
			 Iterator<Map.Entry<String, Object>> it = requiredFieldMap.entrySet().iterator();
			  while (it.hasNext()) {
				  Map.Entry<String, Object> entry = it.next();
				  sql+=" and "+entry.getKey()+"='"+entry.getValue()+"'";
			  }
			BaseService baseService = (BaseService) ApplicationContextUtils.getContext().getBean("baseService");
			List<Map<String, Object>> mapList=baseService.findForMapList(sql);
			if(mapList!=null&&mapList.size()>0){
				addError("第"+getRowNumber()+"行:数据存在重复");
			}
		}
	}

	public void endRow(Map<String, Object> row, T bean)
			throws ValidateException {
	}

	public void error(DataField field, Map<String, Object> row, Exception e) {
	}

	public void fatalError(Exception e) {
	}

	public void end() {
	}


	public void impEnd(){

	}

	public final ImpConfigurator getConf() {
		return this.conf;
	}

	public final Map<String, Object> getParams() {
		return this.params;
	}

	public final HibernatePersister getPersister() {
		return this.persister;
	}

	public final int getIndex() {
		return this.index;
	}

	public final void setIndex(int index) {
		this.index = index;
	}
	/**
	 * 获取行号
	 * @return
	 */
	public final int getRowNumber() {
		return this.rowNumber;
	}

	public final void setRowNumber(int rowNumber) {
		this.rowNumber = rowNumber;
	}
	/**
	 * 获取导入错误行号
	 * @return
	 */
	public int getErrNum() {
		return this.importer.errNum;
	}
	
	public void setSuccNum(int succNum) {
		this.importer.succNum = succNum;
	}
	/**
	 * 获取导入成功行号
	 * @return
	 */
	public int getSuccNum() {
		return this.importer.succNum;
	}
	/**
	 * 获取导入批次编码
	 * @return
	 */
	public String  getBatchCode() {
		return this.importer.getBatchCode();
	}
	public String getMessage(int col, String message) {
		List <DataField> list = this.getConf().getFields();
		return "第"+col+"列（" + list.get(col-1).getTitle() + "）--"+ message;
	}
	
}