//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.biz.eisp.base.importer;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ImportThreadWrapper extends Thread implements Importer, ImportMonitor {
  public static final Log log = LogFactory.getLog("ImportWrapper");
  public static final String STATE_RUNNING = "R";
  public static final String STATE_ERROR = "E";
  public static final String STATE_SUCCESS = "S";
  private Map<String, ImportMonitor> container;
  private String name;
  private Importer importer;
  private DataIterator iterator;
  private boolean test;
  private String impState;
  private ImpInfo impInfo;
  private String errInfo;
  private RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
  private HttpSession httpSession;
  private HttpServletResponse response;

  public ImportThreadWrapper(Importer importer, HttpSession httpSession, HttpServletResponse response) {
    this.importer = importer;
    this.httpSession = httpSession;
    this.response = response;
  }

  @Override
  public boolean isTest() {
    return this.test;
  }

  @Override
  public String getImpState() {
    return this.impState;
  }

  @Override
  public ImpInfo getImpInfo() {
    return this.impInfo;
  }

  @Override
  public String getErrInfo() {
    return this.errInfo;
  }

  @Override
  public int getSize() {
    return this.importer.getIterator() != null ? this.importer.getIterator().getSize() : -1;
  }

  @Override
  public int getIndex() {
    return this.importer.getIterator() != null ? this.importer.getIterator().getIndex() : -1;
  }

  public void render(HttpServletResponse response, String mess, boolean flag) {
    response.setContentType("text/html;charset=utf-8");
    JSONObject obj = new JSONObject();
    obj.put("success", flag);
    obj.put("result", true);
    obj.put("message", mess);
    PrintWriter out = null;

    try {
      out = response.getWriter();
      out.write(obj.toJSONString());
    } catch (IOException var10) {
      var10.printStackTrace();
    } finally {
      if (out != null) {
        out.close();
      }

    }

  }

  @Override
  public void run() {
    RequestContextHolder.setRequestAttributes(this.attributes);
    SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtils.getContext().getBean("sessionFactory");
    Session session = null;
    boolean participate = false;
    if (TransactionSynchronizationManager.hasResource(sessionFactory)) {
      participate = true;
    } else {
      session = sessionFactory.openSession();
      session.setFlushMode(FlushMode.NEVER);
      TransactionSynchronizationManager.bindResource(sessionFactory, new SessionHolder(session));
    }

    try {
      this.impState = "R";
      ImpInfo info = null;
      if (this.test) {
        info = this.importer.test(this.iterator);
      } else {
        info = this.importer.imp(this.iterator, this.httpSession);
      }

      this.impState = "S";
      this.impInfo = info;
    } catch (Exception var304) {
      this.impState = "E";
      this.errInfo = var304.getMessage();
      if (!(var304 instanceof ValidateException)) {
        var304.printStackTrace();
      }
    } finally {
      try {
        if (!participate) {
          TransactionSynchronizationManager.unbindResource(sessionFactory);
          SessionFactoryUtils.closeSession(session);
        }
      } catch (Exception var301) {
        var301.printStackTrace();
      } finally {
        try {
          Thread.sleep(9000L);
        } catch (InterruptedException var300) {
          var300.printStackTrace();
        } finally {
          if (this.container != null) {
            this.container.remove(this.name);
            log.info("container remove; size: " + this.container.size());
          }

        }

      }

    }

  }

  @Override
  public ImpInfo imp(DataIterator iterator, HttpSession session) throws Exception {
    this.test = false;
    this.iterator = iterator;
    this.start();
    return this.impInfo;
  }

  @Override
  public ImpInfo test(DataIterator iterator) throws Exception {
    this.test = true;
    this.iterator = iterator;
    this.start();
    return null;
  }

  @Override
  public void template(HttpServletResponse response) throws Exception {
    this.importer.template(response);
  }

  @Override
  public DataIterator getIterator() {
    return this.importer.getIterator();
  }

  @Override
  public void toContainer(Map<String, ImportMonitor> container, String name) {
    this.container = container;
    this.name = name;
    container.put(name, this);
    log.info("container put; size: " + container.size());
  }
}
