package com.biz.eisp.base.importer;


import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

import org.apache.commons.lang.StringUtils;

import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.ValidateException;


public class MultiLevelDataImporter extends AbstractHibernateImporter
{
  private static final String ROW_NUMBER_NAME = "_r_n";
  protected Map<String, Map<String, String>> rowMap = new LinkedHashMap();
  protected Map<String, Map<String, String>> result = new LinkedHashMap();
  protected DataField parentKeyField;
  protected DataField KeyField;
  protected String parentKeyName;
  protected String keyName;
  protected String name;

  public MultiLevelDataImporter(ImpConfigurator conf, Map<String, Object> params)
    throws Exception
  {
    super(conf, params);
    this.parentKeyField = conf.getMlParentKey();
    this.KeyField = conf.getMlKey();
    this.parentKeyName = this.parentKeyField.getName();
    this.keyName = this.KeyField.getName();

    if (conf.getEntityClass().getSimpleName().equals("BaseOrg")) {
      this.name = "orgName";
    }
    else if (conf.getEntityClass().getSimpleName().equals("BaseEmployee")) {
      this.name = "empName";
    }
    else if (conf.getEntityClass().getSimpleName().equals("BaseDictItem"))
      this.name = "itemName";
  }

  protected void setIterator(DataIterator iterator)
  {
    while (iterator.hasNext()) {
      Map row = (Map)iterator.next();
      row.put("_r_n", iterator.getIndex() + "");
      if (iterator.getIndex() >= this.conf.getStartRow()) {
        String key = (String)row.get(this.keyName);
        if (StringUtils.isNotBlank(key)) {
          this.rowMap.put(key, row);
        }
        else
          this.result.put(UUID.randomUUID().toString(), row);
      }
      else
      {
        this.result.put(UUID.randomUUID().toString(), row);
      }
    }
    try
    {
      for (Iterator<Map<String, String>> iter = this.rowMap.values().iterator(); iter.hasNext(); )
        addRow((Map)iter.next(), 0);
    }
    catch (ValidateException e)
    {
      Iterator iter;
      throw new RuntimeException(e.getMessage());
    }
    if (this.errNum > 0) {
      throw new RuntimeException(this.errors.toString());
    }

    this.iterator = new DataIterator() {
      private Iterator<Map<String, String>> iter = MultiLevelDataImporter.this.result.values().iterator();
      private Map<String, Object> obj;
      private int rowNumber = 0;
      private int index = 0;

      public int getIndex() { return this.index; }

      public int getRowNumber() {
        return this.rowNumber;
      }
      public int getSize() {
        return MultiLevelDataImporter.this.result.size();
      }
      public boolean hasNext() {
        return this.iter.hasNext();
      }
      public Map<String, Object> next() {
        this.index += 1;
        this.obj = ((Map)this.iter.next());
        this.rowNumber = Integer.parseInt((String)this.obj.get("_r_n"));
        return this.obj;
      }
      public void remove() {
        this.iter.remove();
      }
    };
  }

  private void addRow(Map<String, String> row, int layer) throws ValidateException
  {
    if (layer == 10) {
      addError("上级对象不能是自己. (行:" + (String)row.get("_r_n") + ")");
      return;
    }
    if (!this.result.containsKey(row.get(this.keyName))) {
      Map parentRow = (Map)this.rowMap.get(row.get(this.parentKeyName));
      if (parentRow != null) {
        addRow(parentRow, layer + 1);
      }
      this.result.put(row.get(this.keyName), row);
    }
  }

  protected void save(Object object)
  {
    if (this.isTest) {
      String key = this.parentKeyField.getCode() + "." + eval(new Object[] { object }, new StringBuilder().append("${").append(this.KeyField.getCode()).append("}").toString());
      this.objcache.put(key, object);
      return;
    }
    if (this.name != null) {
      this.persister.makeSubCode(this.conf.getEntityClass(), object);
      this.persister.save(object);
      this.persister.makeParentInfo(this.conf.getEntityClass(), object, this.name);
    }
    else {
      super.save(object);
    }
  }
}