package com.biz.eisp.base.importer.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.importer.ImpInfo;
import com.biz.eisp.base.importer.ImportEnum;
import com.biz.eisp.base.importer.ImportMonitor;
import com.biz.eisp.base.importer.ImportMonitorMap;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.ImporterFactory;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.ZipUtils;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.LogManager;


/**
 * 导入功能
 * @author liukai
 *
 */
@Controller
@RequestMapping("/importController")
public class ImportController extends BaseController{
	@Autowired
	private RedisService redisService;
	private Map<String, ImportMonitor> map = ImportMonitorMap.getInstance();
	//获取是否是分布式导入方式或者 是否是直接走redis存储提示方式
	private final boolean isDistributed= false;//(StringUtils.isNotBlank(ResourceUtil.getSysConfigProperty("isDistributed"))&&ResourceUtil.getSysConfigProperty("isDistributed").equals("YES"))?true:false;
	

	@RequestMapping(value = "importData", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView importData(HttpServletRequest request) {
		String impName=request.getParameter("impName");
		Object hiddenTemplete = request.getParameter("hiddenTemplete");
		if (hiddenTemplete ==null || hiddenTemplete.equals("undefined")){
			hiddenTemplete=false;
		}
		request.setAttribute("impName",impName);
		request.setAttribute("hiddenTemplete",hiddenTemplete);
		request.setAttribute("sId", ResourceConfigUtils.getSessionTmUserVo().getUserName()+System.currentTimeMillis());
		request.setAttribute("key", ResourceConfigUtils.getSessionTmUserVo().getUserName()+System.currentTimeMillis());
		return new ModelAndView("com/biz/eisp/importer/importData");
	}
	
	@RequestMapping(value = "save", method = {RequestMethod.GET ,RequestMethod.POST})
	public void save(HttpServletRequest request, HttpServletResponse response) {
		String test = request.getParameter("test");
		String impName = request.getParameter("impName");
		this.cleanFiles(impName);
		String configFile = impName + ".xml";
		String key = request.getParameter("key");
		String mode = request.getParameter("mode");
		String type = request.getParameter("type");
		String zip = request.getParameter("zip");
		InputStream is = null;
		Importer imp = null;
		MultipartFile importFile = null;
		MultipartHttpServletRequest multipartRequest = null;
		Map params;
		if (request instanceof MultipartHttpServletRequest) {
			multipartRequest = (MultipartHttpServletRequest)request;
			params = multipartRequest.getFileMap();
			importFile = (MultipartFile)params.get("Filedata");
		}

		//LogManager.getRootLogger().setLevel(Level.DEBUG);

		try {
			params = this.initParams(request);
			ContextHolderUtils.setCustomerSession(request.getSession());
			if ("2".equals(mode)) {
				imp = ImporterFactory.createImportThreadWrapper(ImporterFactory.createDelayImporter(configFile, params), request.getSession(), response);
			} else {
				imp = ImporterFactory.createImportThreadWrapper(ImporterFactory.createImporter(configFile, params), request.getSession(), response);
			}

			if ("1".equals(request.getParameter("template"))) {
				imp.template(response);
				return;
			}

			String file = null;
			TmUserEntity user = ResourceConfigUtils.getSessionUserName();
			String filedir = System.getProperty("java.io.tmpdir");
			String fileName = filedir + "/" + impName + "_" + user.getUserName() + "_" + System.currentTimeMillis();
			file = fileName + ".sub";
			(new File(file)).getParentFile().mkdirs();
			String gzFile;
			if ("1".equals(zip)) {
				gzFile = fileName + ".zip";
				ZipUtils.createFile(importFile.getInputStream(), gzFile);
				ZipUtils.unzipFirstEntry(gzFile, file);
			} else if ("2".equals(zip)) {
				gzFile = fileName + ".gz";
				ZipUtils.createFile(importFile.getInputStream(), gzFile);
				ZipUtils.ungzFirstEntry(gzFile, file);
			} else {
				ZipUtils.createFile(importFile.getInputStream(), file);
			}

			is = new FileInputStream(file);
			if ("1".equals(test)) {
				if ("xls".equals(type)) {
					imp.test(ImporterFactory.getExcelDataIterator(configFile, is));
				} else {
					imp.test(ImporterFactory.getTextDataIterator(is, type.charAt(0), ImporterFactory.getTextFileCharset(file)));
				}

				((ImportMonitor)imp).toContainer(this.map, key);
				this.renderText(response, key, true);
			} else if (!"2".equals(mode)) {
				if ("xls".equals(type)) {
					imp.imp(ImporterFactory.getExcelDataIterator(configFile, is), request.getSession());
				} else {
					imp.imp(ImporterFactory.getTextDataIterator(is, type.charAt(0), ImporterFactory.getTextFileCharset(file)), request.getSession());
				}

				((ImportMonitor)imp).toContainer(this.map, key);
				this.renderText(response, key, true);
			}
		} catch (Throwable var23) {
			var23.printStackTrace();
			(new StringBuilder()).append("导入失败").append("！").append(var23.getMessage()).toString();
			this.renderText(response, "导入失败", false);
		} finally {
			//LogManager.getRootLogger().setLevel(Level.INFO);
		}
	}

	@ResponseBody
	@RequestMapping(value = "info", method = {RequestMethod.GET, RequestMethod.POST})
	public AjaxJson info(String keyname) {
		AjaxJson j=new AjaxJson();
		String mess = "";
		boolean isEnd=false;
		if (isDistributed){
			try {
				if (redisService.hasKey(keyname)){
				Object state=	redisService.hget(keyname, ImportEnum.ImpState.getValue());
				if (state!=null) {
					if (state.equals("R")) {
						Object sStr=redisService.hget(keyname, ImportEnum.Size.getValue());
						int size = sStr!=null?Integer.valueOf(sStr.toString()):0;
						Object IndexStr=redisService.hget(keyname, ImportEnum.Index.getValue());
						int index = IndexStr!=null?Integer.valueOf(IndexStr.toString()):0;
						mess = new StringBuilder().append(" ").append("导入进度:").append(
								size == -1 ? "..." : "共" + Integer.valueOf(size - 1) + "条数据，正在导入第")
								.append(index == -1 ? "..." : Integer.valueOf(index) + "条数据...").toString();
					} else if (state.equals("S")) {
						Object ImpInfoStr=redisService.hget(keyname, ImportEnum.ImpInfo.getValue());
						ImpInfo info = JsonUtil.jsonToObject(ImpInfoStr.toString(),ImpInfo.class);
						String messKey = "导入成功";
						messKey = format("导入成功！成功行数{0}",
								info.getSuccNum());
						mess = new StringBuilder().append("S").append(messKey)
								.toString();
						if (StringUtils.isNotBlank(info.getMessages())) {
							mess = new StringBuilder().append(mess).append("<p/>")
									.toString();
							mess = new StringBuilder().append(mess).append("[").append(
									"忽略错误信息")
									.append("]").append("<br/>").toString();
							mess = new StringBuilder().append(mess).append(
									info.getMessages()).toString();
						}
						isEnd = true;
					} else if (state.equals("E")) {
						Object errInfo = redisService.hget(keyname, ImportEnum.errInfo.getValue());
						mess = new StringBuilder().append("E").append(
								"导入失败").append(
								"！!").toString();
						mess = new StringBuilder().append(mess).append("</p>")
								.toString();
						mess = new StringBuilder().append(mess).append("[").append(
								"导入失败信息").append("]")
								.append("</br>").toString();
						mess = new StringBuilder().append(mess)
								.append(errInfo).toString();
						isEnd = true;
					}
				}
				}
			} catch (Exception e) {
				e.printStackTrace();
				mess = new StringBuilder().append("E").append(
						"导入失败").append(
						"！!").toString();
				mess = new StringBuilder().append(mess).append("</p>")
						.toString();
				mess = new StringBuilder().append(mess).append("[").append(
						"导入失败信息").append("]")
						.append("</br>").toString();
				mess = new StringBuilder().append(e.getMessage()).toString();
				isEnd=true;
			}

		}else {
			ImportMonitor mon = (ImportMonitor) this.map.get(keyname);

			if ((mon != null) && (mon.getImpState() != null)) {
				String state = mon.getImpState();
				if (state.equals("R")) {
					int size = mon.getSize();
					int index = mon.getIndex();
					mess = new StringBuilder().append(" ").append("导入进度:").append(
							size == -1 ? "..." : "共" + Integer.valueOf(size - 1) + "条数据，正在导入第")
							.append(index == -1 ? "..." : Integer.valueOf(index) + "条数据...").toString();
				} else if (state.equals("S")) {
					ImpInfo info = mon.getImpInfo();
					String messKey = mon.isTest() ? "测试成功"
							: "导入成功";
					messKey = format("导入成功！成功行数{0}",
							info.getSuccNum());
					mess = new StringBuilder().append("SUCCESS").append(messKey)
							.toString();
					if (StringUtils.isNotBlank(info.getMessages())) {
						mess = new StringBuilder().append(mess).append("<p/>")
								.toString();
						mess = new StringBuilder().append(mess).append("[").append(
								"忽略错误信息")
								.append("]").append("<br/>").toString();
						mess = new StringBuilder().append(mess).append(
								info.getMessages()).toString();
					}
					isEnd=true;
				} else if (state.equals("E")) {
					mess = new StringBuilder().append("ERROR").append(
							"导入失败").append(
							"！!").toString();
					mess = new StringBuilder().append(mess).append("</p>")
							.toString();
					mess = new StringBuilder().append(mess).append("[").append(
							"导入失败信息").append("]")
							.append("</br>").toString();
					mess = new StringBuilder().append(mess)
							.append(mon.getErrInfo()).toString();
					isEnd=true;
				}
			}
		}
		j.setMsg(mess);
		j.setSuccess(isEnd);
		return j;
	}

	private String format(String str, Object... args) {
		for (int i = 0; i < args.length; i++) {
			if (null == args[i]) {
				str = str.replace("{" + i + "}", "null");
				continue;
			}
			str = str.replace("{" + i + "}", args[i].toString());
		}
		return str;
	}
	
	public void renderText(HttpServletResponse response, String mess,
			boolean flag) {
		response.setContentType("text/html;charset=utf-8");
		JSONObject obj = new JSONObject();
		obj.put("success", flag);
		obj.put("result", true);
		obj.put("message", mess);
		PrintWriter out = null;
		try {
			out = response.getWriter();
			out.write(obj.toJSONString());
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				out.close();
			}
		}
	}
	
	private byte[] toBytes(InputStream is) throws IOException {
		ByteArrayOutputStream baout = new ByteArrayOutputStream();
		int cachesize = 2048;
		byte[] b = new byte[2048];
		int n;
		while ((n = is.read(b)) != -1) {
			baout.write(b, 0, n);
		}
		return baout.toByteArray();
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Map<String, Object> initParams(HttpServletRequest request) {
		TmUserEntity user = (TmUserEntity) ResourceConfigUtils.getSessionUserName();
		Map params = new HashMap();
		params.put("_user", user);

		Date date = new Date();
		params.put("_currDate", DateUtils.formatDate(date, "yyyy-MM-dd"));
		params.put("_currTime", DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss"));
		params.put("_currMillis", new StringBuilder().append(date.getTime())
				.append("").toString());
		params.put("_uuid", UUID.randomUUID().toString());

		Enumeration names = request.getParameterNames();
		while (names.hasMoreElements()) {
			String name = names.nextElement().toString();
			params.put(name, request.getParameter(name));
		}
		return params;
	}

	private void cleanFiles(String impName) {
		try {
			String fn = impName;
			if (fn.indexOf('/') != -1) {
				fn = fn.substring(fn.lastIndexOf('/') + 1);
			}
			final String fileName = fn;

			String filepath = new StringBuilder().append(
					System.getProperty("java.io.tmpdir")).append("/").append(
					impName).toString();
			String filedir = filepath.substring(0, filepath.lastIndexOf('/'));

			long fd = 432000000L;
			final long tm = System.currentTimeMillis() - 432000000L;

			File file = new File(filedir);
			File[] files = file.listFiles(new FileFilter() {
				public boolean accept(File file) {
					if ((file.isFile())
							&& (file.getName().startsWith(fileName))
							&& (file.lastModified() < tm)) {
						return true;
					}
					return false;
				}
			});
			for (File f : files)
				f.delete();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
