package com.biz.eisp.base.importer.iterator;

import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;

public class Excel2007DataIterator implements DataIterator {
	private XSSFSheet sheet;
	private int rows = -1;
	private int index;
	private List<DataField> dataFieldList;
	private DataFormatter dataFormatter = new DataFormatter();
	private XSSFCellStyle dateStyle;

	public Excel2007DataIterator(InputStream is, int sheetIndex,List<DataField> dataFieldList)
			throws Exception {
		XSSFWorkbook wb = new XSSFWorkbook(is);
		this.sheet = wb.getSheetAt(sheetIndex);
		this.rows = (this.sheet.getLastRowNum() + 1);
		this.index = 0;
		this.dataFieldList=dataFieldList;
		XSSFDataFormat format = wb.createDataFormat();
		this.dateStyle = wb.createCellStyle();

		this.dateStyle.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
	}

	public boolean hasNext() {
		return this.index < this.rows;
	}

	public Map<String, Object> next() {
		XSSFRow cells = this.sheet.getRow(this.index++);
		Map<String,Object> rowMap = new HashMap<String,Object>();
		if (cells == null) {
			return rowMap;
		}
		for (int cellIdx = 0; cellIdx < cells.getLastCellNum(); cellIdx++) {
			XSSFCell cell = cells.getCell(cellIdx);
			String value = "";
			if (cell != null) {
				if ((cell.getCellType() == 0)
						&& (DateUtil.isCellDateFormatted(cell))
						&& (cell.getCellStyle() != null)) {
					cell.setCellStyle(this.dateStyle);
				}

				if (cell.getCellType() == 5)
					value = cell.toString();
				else {
					value = this.dataFormatter.formatCellValue(cell).trim();
				}
			}
			StringBuilder idx = new StringBuilder();
			idx.append(cellIdx + 1);
			DataField dataField=dataFieldList.get(cellIdx);
			if(StringUtil.isNotEmpty(value)&&dataField!=null
					&&StringUtil.isNotEmpty(dataField.getDictCode())){
				String dictCode=dataField.getDictCode();
				String valueStr=DictUtil.getDictCodeByValue(dictCode, value);
				if(StringUtil.isNotEmpty(valueStr)){
					value=valueStr;
				}
			}
			if(StringUtil.isNotEmpty(dataField.getFormat())){
				rowMap.put(dataField.getCode(), DateUtils.parse(value,dataField.getFormat()));
			}else{
				rowMap.put(dataField.getCode(), value);
			}
		
		}
		return rowMap;
	}

	public void remove() {
	}

	public int getIndex() {
		return this.index;
	}

	public int getRowNumber() {
		return this.index;
	}

	public int getSize() {
		return this.rows;
	}
}